/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.connect.oauth;

import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.scribe.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils {
    private static Logger log = LoggerFactory.getLogger(ProviderUtils.class);

    public static Map<String, String> parseProfileDataResponse(Response response) throws IOException {
        String body = response.getBody();
        try {
            JSONObject json = new JSONObject(body);
            HashMap<String, String> newProps = new HashMap<String, String>();
            Iterator<String> keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                newProps.put(key, json.optString(key));
            }
            return newProps;
        }
        catch (JSONException je) {
            log.debug("problem parsing JSON; response body was: {}", (Object)body);
            throw new IOException(je.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importAvatarFile(Node userNode, String avatarURL, String avatarFileProperty) throws IOException, RepositoryException {
        Session session = userNode.getSession();
        if (avatarURL != null && avatarURL.startsWith("http")) {
            InputStream ins = null;
            try {
                HttpClient client = new HttpClient();
                GetMethod method = new GetMethod(avatarURL);
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    String mimeType = method.getResponseHeader("Content-Type").getValue();
                    ins = method.getResponseBodyAsStream();
                    Binary binary = session.getValueFactory().createBinary(ins);
                    Node imageNode = JcrUtil.createPath(userNode, avatarFileProperty, false, "sling:Folder", "nt:file", session, false);
                    Node contentNode = imageNode.addNode("jcr:content", "nt:resource");
                    contentNode.setProperty("jcr:data", binary);
                    contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    contentNode.setProperty("jcr:mimeType", mimeType);
                    session.save();
                }
            }
            finally {
                IOUtils.closeQuietly(ins);
                ins = null;
            }
        }
    }
}

