/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.security;

import com.adobe.cq.social.commons.SaferSlingPostValidator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component(immediate=true, specVersion="1.1", metatype=false)
@Service(value={Servlet.class, Filter.class})
@Properties(value={@Property(name="service.description", value={"AEM Social Communities Safer Sling Post Servlet"}, propertyPrivate=true), @Property(name="service.vendor", value={"Adobe Systems Incorporated"}, propertyPrivate=true), @Property(name="service.ranking", intValue={2147482647}, propertyPrivate=true), @Property(name="sling.filter.scope", value={"REQUEST"}, propertyPrivate=true), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"social"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"POST"}, propertyPrivate=true)})
public class SaferSlingPostServlet
extends SlingAllMethodsServlet
implements Filter,
OptingServlet {
    static final String POST_SERVLET_RESOURCE_TYPE = "sling/servlet/default";
    private static final long serialVersionUID = 1L;
    private static final String DROP_SELECTORS_ATTRIBUTE = SaferSlingPostServlet.class.getName() + ".dropSelectors";
    private static final String ACCEPTED_ATTRIBUTE = SaferSlingPostServlet.class.getName() + ".accepted";
    @Reference
    private SaferSlingPostValidator validator;

    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.validator.reject(request)) {
            response.sendError(400);
            return;
        }
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (request.getAttribute(DROP_SELECTORS_ATTRIBUTE) != null) {
            options.setReplaceSelectors("");
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(request.getRequestPathInfo().getResourcePath(), options);
        request.setAttribute(ACCEPTED_ATTRIBUTE, true);
        dispatcher.include((ServletRequest)request, (ServletResponse)response);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof SlingHttpServletRequest) || !"POST".equals(((SlingHttpServletRequest)request).getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        SlingHttpServletRequest httpReq = (SlingHttpServletRequest)request;
        RequestPathInfo rpi = httpReq.getRequestPathInfo();
        String selector = this.checkSelectors(httpReq, rpi);
        if (selector == null) {
            selector = this.checkSuffix(httpReq, rpi);
        }
        if (selector != null) {
            this.include(httpReq, response, rpi, selector);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private String checkSelector(ServletRequest request, String selector) {
        if ("social".equals(selector)) {
            return selector;
        }
        if (selector.startsWith("social-")) {
            try {
                int depth = Integer.parseInt(selector.substring(selector.lastIndexOf(45) + 1));
                request.setAttribute(SaferSlingPostValidator.POST_DEPTH_ATTRIBUTE, (Object)depth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (selector.contains("-drop-selectors-")) {
                request.setAttribute(DROP_SELECTORS_ATTRIBUTE, (Object)true);
            }
            return selector;
        }
        return null;
    }

    private String checkSelectors(SlingHttpServletRequest request, RequestPathInfo rpi) {
        String[] selectors;
        for (String s : selectors = rpi.getSelectors()) {
            String selector = this.checkSelector((ServletRequest)request, s);
            if (selector == null) continue;
            return selector;
        }
        return null;
    }

    private String checkSuffix(SlingHttpServletRequest request, RequestPathInfo rpi) {
        String last;
        String[] splitSuffix;
        String suffix = rpi.getSuffix();
        if (suffix != null && (splitSuffix = (last = suffix.substring(suffix.lastIndexOf(47) + 1)).split("[.]")).length > 2) {
            for (int i = 1; i < splitSuffix.length - 1; ++i) {
                String selector = this.checkSelector((ServletRequest)request, splitSuffix[i]);
                if (selector == null) continue;
                return selector;
            }
        }
        return null;
    }

    private void include(SlingHttpServletRequest request, ServletResponse response, RequestPathInfo rpi, String selector) throws ServletException, IOException {
        String tag = (String)request.getAttribute(SaferSlingPostServlet.class.getName());
        if (tag == null) {
            request.setAttribute(SaferSlingPostServlet.class.getName(), "true");
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (!"social".equals(selector)) {
                options.setReplaceSelectors("social." + rpi.getSelectorString());
            }
            if (selector.contains("-force-intercept-")) {
                options.setForceResourceType(POST_SERVLET_RESOURCE_TYPE);
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(request.getRequestPathInfo().getResourcePath(), options);
            dispatcher.include((ServletRequest)request, response);
            return;
        }
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        return request.getAttribute(ACCEPTED_ATTRIBUTE) == null;
    }

    protected void bindValidator(SaferSlingPostValidator saferSlingPostValidator) {
        this.validator = saferSlingPostValidator;
    }

    protected void unbindValidator(SaferSlingPostValidator saferSlingPostValidator) {
        if (this.validator == saferSlingPostValidator) {
            this.validator = null;
        }
    }
}

