/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.SocialCollectionComponent;
import com.day.cq.wcm.api.Page;
import org.apache.commons.lang3.StringUtils;

public class PageInfo {
    private final String urlPattern;
    private long totalItems = -1L;
    private final CollectionPagination pagination;
    private final String params;
    private final String basePageURL;
    private final SocialCollectionComponent component;

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination) {
        this(component, clientUtils, pagination, null);
    }

    public PageInfo(SocialCollectionComponent component, ClientUtilities clientUtils, CollectionPagination pagination, String params) {
        this.pagination = pagination;
        Page page = clientUtils.getContainingPage(component.getId().toString());
        this.basePageURL = page != null && !StringUtils.isEmpty((CharSequence)pagination.getSelectedIndex()) ? clientUtils.externalLink(page.getPath() + ".index." + pagination.getSelectedIndex(), false) : (page != null ? clientUtils.externalLink(page.getPath(), false) : null);
        this.urlPattern = clientUtils.externalLink(component.getId() + ".social" + "." + "${startIndex}." + Long.valueOf(this.getPageSize()).toString() + "." + clientUtils.getRequestExtension(), false);
        this.params = params;
        this.component = component;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public long getSelectedPage() {
        Double pagesSeen = Math.ceil((long)this.pagination.getOffset() / Math.abs(this.getPageSize()));
        if (this.pagination.getSize() == 0) {
            return pagesSeen.longValue();
        }
        return Double.valueOf(pagesSeen + 1.0).longValue();
    }

    public long getTotalPages() {
        return Double.valueOf(Math.ceil((double)this.getTotalItems() * 1.0 / (double)Math.abs(this.getPageSize()))).longValue();
    }

    public long getPageSize() {
        return this.pagination.getSize() > 0 ? (long)this.pagination.getSize() : (long)this.pagination.getPageSizeConfig();
    }

    public long getCurrentIndex() {
        return this.pagination.getOffset();
    }

    public String getNextPageURL() {
        String nextPage = StringUtils.replace((String)this.getURLPattern(), (String)"${startIndex}", (String)Long.valueOf(this.getNextOffset()).toString());
        if (this.params != null) {
            nextPage = nextPage + "?" + this.params;
        }
        return nextPage;
    }

    public String getPreviousPageURL() {
        String nextPage = StringUtils.replace((String)this.getURLPattern(), (String)"${startIndex}", (String)Long.valueOf(this.getPreviousOffset()).toString());
        if (this.params != null) {
            nextPage = nextPage + "?" + this.params;
        }
        return nextPage;
    }

    public String getNextSuffix() {
        return this.getNextOffset() + "." + this.getPageSize();
    }

    public String getPreviousSuffix() {
        return this.getPreviousOffset() + "." + this.getPageSize();
    }

    public String getSelectedIndex() {
        return this.pagination.getSelectedIndex();
    }

    public String getBasePageURL() {
        return this.basePageURL;
    }

    private long getTotalItems() {
        if (this.totalItems < 0L) {
            this.totalItems = this.component.getTotalSize();
        }
        return this.totalItems;
    }

    private long getNextOffset() {
        return this.getTotalItems() < (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset()) ? this.getTotalItems() : (long)(Math.abs(this.pagination.getSize()) + this.pagination.getOffset());
    }

    private long getPreviousOffset() {
        return 0 >= this.pagination.getOffset() - Math.abs(this.pagination.getSize()) ? 0L : (long)(this.pagination.getOffset() - Math.abs(this.pagination.getSize()));
    }
}

