/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.CollectionSortedOrder;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.ResourceID;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.PageInfo;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentList;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProvider;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.ugcbase.SocialException;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Calendar;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommentCollection<C extends Comment, T extends CommentCollectionConfiguration>
extends BaseSocialComponent
implements CommentCollection<C, T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentCollection.class);
    private CommentSocialComponentListProviderManager commentListProviderManager;
    private Calendar lastModified;
    private Calendar created;
    private CommentSocialComponentList comments;
    private QueryRequestInfo queryInfo;
    private PageInfo pageInfo;
    private CommentSystem cs;
    private T configuration;

    public AbstractCommentCollection(ResourceID id, ResourceResolver resolver, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) {
        this(resolver.resolve(id.getResourceIdentifier()), clientUtils, commentListProviderManager);
    }

    public AbstractCommentCollection(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) {
        super(resource, clientUtils);
        this.init(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), false, commentListProviderManager);
    }

    public AbstractCommentCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager commentListProviderManager) {
        super(resource, clientUtils);
        this.init(resource, clientUtils, queryInfo, true, commentListProviderManager);
    }

    private void init(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, boolean buildPages, CommentSocialComponentListProviderManager commentListProviderManager) throws SocialException {
        this.queryInfo = queryInfo;
        this.setCommentListProviderManager(commentListProviderManager);
        this.cs = resource.adaptTo(CommentSystem.class);
        this.setLastModified(this.cs.getLastModified());
        this.setCreated(this.cs.getCreated());
        this.configuration = this.createConfiguration(resource, this.cs);
        QueryRequestInfo commentsQueryInfo = QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(queryInfo);
        commentsQueryInfo.setSortOrder(CollectionSortedOrder.REVERSED_ORDER);
        CollectionPagination currentPagination = commentsQueryInfo.getPagination();
        commentsQueryInfo.setPagination(new CollectionPagination(currentPagination.getOffset(), queryInfo.getPagination() == CollectionPagination.DEFAULT_PAGINATION ? this.configuration.getPageSize() : currentPagination.getSize(), currentPagination.getEmbedLevel() + 1, currentPagination.getSelectedIndex(), this.configuration.getPageSize()));
        CommentSocialComponentListProvider listProvider = this.getCommentListProviderManager().getCommentSocialComponentListProvider(resource, commentsQueryInfo);
        if (listProvider == null) {
            throw new SocialException(String.format("Could not find a SCF list provider for %1$s whose resource type is: %2$s.", resource.getPath(), resource.getResourceType()));
        }
        this.comments = listProvider.getCommentSocialComponentList(this, commentsQueryInfo, clientUtils);
        this.pageInfo = new PageInfo(this, clientUtils, commentsQueryInfo.getPagination());
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.queryInfo.setPagination(pagination);
        this.comments.setPagination(pagination);
        this.pageInfo = new PageInfo(this, this.clientUtils, pagination);
    }

    protected CollectionPagination getPagination() {
        return this.queryInfo.getPagination();
    }

    protected QueryRequestInfo getQueryRequestInfo() {
        return this.queryInfo;
    }

    @Override
    public Calendar getCreated() {
        return this.created;
    }

    @Override
    public Calendar getLastModified() {
        return this.lastModified;
    }

    @Override
    public int getTotalSize() {
        return this.comments.getTotalSize();
    }

    @Override
    public List<Object> getItems() {
        return this.comments;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.comments.setSortedOrder(sortedOrder);
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    @JsonIgnoreProperties
    public boolean isTaggingAllowed() {
        return Boolean.parseBoolean(this.properties.getProperty("allowTagging", "false"));
    }

    protected void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    protected void setCreated(Calendar created) {
        this.created = created;
    }

    protected CommentSocialComponentListProviderManager getCommentListProviderManager() {
        return this.commentListProviderManager;
    }

    protected void setCommentListProviderManager(CommentSocialComponentListProviderManager commentListProviderManager) {
        this.commentListProviderManager = commentListProviderManager;
    }

    @Override
    public T getConfiguration() {
        return this.configuration;
    }

    @Override
    public T createConfiguration(Resource resource, CommentSystem cs) {
        return (T)new AbstractCommentCollectionConfiguration(resource, cs);
    }

    protected CommentSystem getCommentSystem() {
        return this.cs;
    }
}

