/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.CollectionSortedOrder;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponentFactoryManager;
import com.adobe.cq.social.commons.client.api.User;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.PageInfo;
import com.adobe.cq.social.commons.comments.listing.CommentIndexElementFactory;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentList;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProvider;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.commons.comments.listing.impl.CommentIndexElementFactoryImpl;
import com.adobe.cq.social.commons.moderation.impl.FlagReason;
import com.adobe.cq.social.commons.tagging.SocialTagManager;
import com.adobe.cq.social.tally.Response;
import com.adobe.cq.social.tally.TallyException;
import com.adobe.cq.social.tally.Vote;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.translation.TranslationUtil;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.tagging.Tag;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComment<T extends CommentCollectionConfiguration>
extends BaseSocialComponent
implements Comment<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComment.class);
    private static final String UNKNOWN_USER = "Unknown";
    protected final CommentSocialComponentList replies;
    private final User author;
    private final Map<String, Attachment> attachments;
    private final Calendar created;
    private final String message;
    private final String parentPath;
    private final String resourceType;
    private final boolean isTopLevel;
    private final boolean isApproved;
    private boolean canEdit = false;
    private boolean canDelete = false;
    private boolean userIsModerator = false;
    private boolean currentUserFlagged = false;
    private String currentUserFlagText = null;
    private final QueryRequestInfo queryInfo;
    private final boolean isVisible;
    private final boolean isClosed;
    private final boolean doDisplayTranslation;
    private final boolean displayReplyButton;
    private T configuration;
    private final Comment.ModeratorActions moderatorActions;
    private final Comment.ModeratorStatus moderatorStatus;
    private final String votingRoot;
    private boolean useFlagReasonList = true;
    private boolean useFlagReasons = false;
    private List<FlagReason> flagReasons;
    private CommentSocialComponentListProviderManager commentListProviderManager;
    private final com.adobe.cq.social.commons.Comment comment;
    private PageInfo pageInfo;

    public AbstractComment(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), commentListProviderManager);
    }

    public AbstractComment(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager commentListProviderManager) throws RepositoryException {
        super(resource, clientUtils);
        this.commentListProviderManager = commentListProviderManager;
        this.comment = resource.adaptTo(com.adobe.cq.social.commons.Comment.class);
        this.author = this.clientUtils.getUser(this.comment.getAuthor().getId(), this.comment.getResource().getResourceResolver());
        this.attachments = this.comment.getAttachments();
        this.created = this.comment.getCreated();
        this.message = this.comment.getMessage();
        this.parentPath = this.comment.getComponent().getPath();
        this.isTopLevel = this.comment.isTopLevel();
        this.queryInfo = queryInfo;
        this.flagReasons = new ArrayList<FlagReason>();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String userId = session.getUserID();
        CommentSystem cs = this.comment.getCommentSystem();
        this.isApproved = this.comment.isApproved() || !cs.isModerated();
        this.userIsModerator = clientUtils.getSocialUtils().hasModeratePermissions(resource);
        boolean userIsLoggedIn = clientUtils == null ? userId != null && !userId.equalsIgnoreCase("Anonymous") : !clientUtils.userIsAnonymous();
        this.isClosed = this.comment.isClosed();
        this.configuration = this.createConfiguration(resource, cs);
        if ((this.userIsModerator || this.userIsOwner() && userIsLoggedIn) && !this.isClosed) {
            this.canEdit = true;
        }
        if ((this.userIsModerator || this.userIsOwner() && userIsLoggedIn && cs.allowsDelete()) && !this.isClosed) {
            this.canDelete = true;
        }
        this.isVisible = this.userIsModerator || !this.comment.isSpam() && !this.comment.isFlaggedHidden() && this.isApproved;
        this.displayReplyButton = cs.allowsReplies() && !this.isClosed;
        this.moderatorStatus = this.userIsModerator ? new ModeratorStatusImpl(this.comment, cs) : null;
        this.moderatorActions = new ModeratorActionsImpl(this.comment, cs, userIsLoggedIn);
        if (cs.allowsFlagging()) {
            this.useFlagReasonList = cs.useFlagReasonList();
            this.useFlagReasons = this.useFlagReasonList || cs.allowCustomFlagReason();
            Response<Vote> response = this.getFlagResponseForUser(userId);
            if (response != null && response.getResponseValue() != null) {
                this.currentUserFlagged = true;
                if (this.useFlagReasons) {
                    Resource responseResource = response.getResource();
                    ValueMap resourceProperties = responseResource.adaptTo(ValueMap.class);
                    this.currentUserFlagText = resourceProperties.get("social:flagReason", "");
                }
            }
            if (this.userIsModerator && this.useFlagReasons) {
                this.flagReasons = this.listFlagReasons(resource, clientUtils);
            }
        }
        this.resourceType = this.comment.getResource().getResourceType();
        if (queryInfo.isQuery()) {
            List emptyList = Collections.emptyList();
            this.replies = CommentSocialComponentList.EMPTY_LIST;
        } else {
            QueryRequestInfo repliesListInfo = QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(queryInfo);
            CollectionPagination currentPagination = repliesListInfo.getPagination();
            CollectionPagination repliesPagination = currentPagination.getEmbedLevel() != 0 ? new CollectionPagination(0, 0, currentPagination.getEmbedLevel() + 1, currentPagination.getSelectedIndex(), this.configuration.getPageSize()) : new CollectionPagination(currentPagination.getOffset(), queryInfo.getPagination() == CollectionPagination.DEFAULT_PAGINATION ? this.configuration.getPageSize() : currentPagination.getSize(), currentPagination.getEmbedLevel() + 1, currentPagination.getSelectedIndex(), this.configuration.getPageSize());
            repliesListInfo.setPagination(repliesPagination);
            repliesListInfo.setSortOrder(CollectionSortedOrder.DEFAULT_ORDER);
            CommentSocialComponentListProvider listProvider = this.commentListProviderManager.getCommentSocialComponentListProvider(resource, repliesListInfo);
            this.replies = listProvider.getCommentSocialComponentList(this, repliesListInfo, clientUtils);
            this.pageInfo = new PageInfo(this, clientUtils, repliesListInfo.getPagination());
        }
        this.doDisplayTranslation = TranslationUtil.doDisplayTranslation(resource.getResourceResolver(), resource, clientUtils);
        Resource component = cs.getResource();
        this.votingRoot = CommentUtil.getVotingRoot(component);
    }

    @Override
    public T createConfiguration(Resource resource, CommentSystem cs) {
        return (T)new AbstractCommentCollectionConfiguration(resource, cs);
    }

    @Override
    public T getConfiguration() {
        return this.configuration;
    }

    private boolean userIsOwner() {
        Session session = this.resource.getResourceResolver().adaptTo(Session.class);
        ValueMap map = this.resource.adaptTo(ValueMap.class);
        String resourceAuthorID = (String)((Object)map.get("userIdentifier", String.class));
        if (StringUtils.isEmpty((String)resourceAuthorID)) {
            resourceAuthorID = (String)((Object)map.get("jcr:lastModifiedBy", String.class));
        }
        return StringUtils.equals((String)session.getUserID(), (String)resourceAuthorID);
    }

    private String getFlagsPath() {
        ValueMap props = this.resource.adaptTo(ValueMap.class);
        if (props == null) {
            LOG.warn("Unable to adapt resource {} to ValueMap.");
            return null;
        }
        int flagAllowCount = props.get("social:flagAllowCount", 0);
        return this.resource.getPath() + "/flags_" + flagAllowCount;
    }

    private Response<Vote> getFlagResponseForUser(String currentUserId) throws RepositoryException {
        ResourceResolver resolver = this.resource.getResourceResolver();
        String flagsPath = this.getFlagsPath();
        if (flagsPath == null) {
            return null;
        }
        Resource flagResource = resolver.resolve(flagsPath);
        if (ResourceUtil.isNonExistingResource(flagResource)) {
            return null;
        }
        Voting voting = flagResource.adaptTo(Voting.class);
        Response<Vote> response = null;
        try {
            response = voting.getUserResponse(currentUserId);
        }
        catch (RepositoryException e) {
            LOG.error("Repository Exception getting voting response for user {}.", (Object)currentUserId);
        }
        catch (TallyException e) {
            LOG.error("Tally Exception getting voting response for user {}.", (Object)currentUserId);
        }
        return response;
    }

    private List<FlagReason> listFlagReasons(Resource resource, ClientUtilities clientUtils) throws RepositoryException {
        ArrayList<FlagReason> reasons = new ArrayList<FlagReason>();
        ResourceResolver resolver = resource.getResourceResolver();
        String flagsPath = this.getFlagsPath();
        if (flagsPath == null) {
            return reasons;
        }
        Resource flagResource = resolver.resolve(flagsPath);
        if (!ResourceUtil.isNonExistingResource(flagResource)) {
            Voting voting = flagResource.adaptTo(Voting.class);
            Iterator responses = voting.getResponses(0L);
            while (responses.hasNext()) {
                Response response = responses.next();
                Resource responseResource = response.getResource();
                ValueMap resourceProperties = responseResource.adaptTo(ValueMap.class);
                String flagReasonText = (String)resourceProperties.get("social:flagReason");
                FlagReason flagReason = new FlagReason(flagReasonText);
                String flagUserId = response.getUserId();
                UserProperties userProps = clientUtils.getSocialUtils().getUserProperties(resolver, flagUserId);
                String flagUser = userProps != null ? userProps.getDisplayName() : UNKNOWN_USER;
                flagReason.setUser(flagUser);
                reasons.add(flagReason);
            }
        }
        return reasons;
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        this.ignoredProperties.add("userIdentifier");
        this.ignoredProperties.add("referer");
        this.ignoredProperties.add("authorizableId");
        return this.ignoredProperties;
    }

    @Override
    public Attachment getAttachment(String name) {
        return this.attachments.get(name);
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public Calendar getCreated() {
        return this.created;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getMessage() {
        return this.clientUtils.filterHTML(this.message);
    }

    public String getParent() {
        return this.externalizeURL(this.parentPath);
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.replies.setPagination(pagination);
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.replies.setSortedOrder(sortedOrder);
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isApproved() {
        return this.isApproved;
    }

    @Override
    public boolean getCanEdit() {
        return this.canEdit;
    }

    @Override
    public boolean getCanReply() {
        return this.displayReplyButton;
    }

    @Override
    public boolean getCanDelete() {
        return this.canDelete;
    }

    @Override
    public int getTotalSize() {
        return this.replies.getTotalSize();
    }

    @Override
    public List<Object> getItems() {
        return this.replies;
    }

    @Override
    public String getParentId() {
        return this.parentPath;
    }

    @Override
    public boolean getCanTranslate() {
        return this.doDisplayTranslation;
    }

    @Override
    public boolean isUserModerator() {
        return this.userIsModerator;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public List<FlagReason> getFlagReasons() {
        return this.flagReasons;
    }

    @Override
    public String getCurrentUserFlagText() {
        return this.currentUserFlagText;
    }

    @Override
    public boolean getUseFlagReasons() {
        return this.useFlagReasons;
    }

    @Override
    public boolean isFlaggedByUser() {
        return this.currentUserFlagged;
    }

    @Override
    public SocialComponent getVotes() {
        if (this.configuration.isVotingAllowed()) {
            SocialComponentFactory scf;
            SocialComponentFactoryManager scfMgr;
            Resource voteResource = this.resource.getChild(this.votingRoot);
            if (voteResource == null || ResourceUtil.isNonExistingResource(voteResource)) {
                voteResource = new SyntheticResource(this.resource.getResourceResolver(), this.resource.getPath() + "/" + this.votingRoot, "social/tally/components/voting");
            }
            if ((scfMgr = this.clientUtils.getSocialComponentFactoryManager()) != null && (scf = scfMgr.getSocialComponentFactory(voteResource)) != null) {
                return scf.getSocialComponent(voteResource, this.clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create());
            }
        }
        return null;
    }

    @Override
    public Comment.ModeratorActions getModeratorActions() {
        return this.moderatorActions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Comment.ModeratorStatus getModeratorStatus() {
        return this.moderatorStatus;
    }

    protected CommentIndexElementFactory getIndexElementFactory() {
        return new CommentIndexElementFactoryImpl(this.clientUtils, this.queryInfo);
    }

    protected List<Comment> getComments() throws RepositoryException {
        return this.replies.getComments();
    }

    protected CollectionPagination getPagination() {
        return this.queryInfo.getPagination();
    }

    protected QueryRequestInfo getQueryRequestInfo() {
        return this.queryInfo;
    }

    @Override
    public List<Comment.Tag> getTags() {
        Tag[] userTags;
        block6: {
            SocialTagManager tm = this.getResource().getResourceResolver().adaptTo(SocialTagManager.class);
            userTags = new Tag[]{};
            try {
                userTags = tm.getTags(this.getResource());
            }
            catch (Exception e) {
                if (userTags == null || userTags.length > 0) break block6;
                try {
                    if (this.getProperties().get("cq:tags") != null && !this.getProperties().get("cq:tags").getClass().isArray()) {
                        String tag = null;
                        tag = this.getProperties().get("cq:tags").toString();
                        Tag singleTag = tm.resolve(tag);
                        userTags = new Tag[]{singleTag};
                    }
                }
                catch (Exception e1) {
                    LOG.error("Error retrieving tags: ", (Throwable)e1);
                }
            }
        }
        ArrayList<Comment.Tag> tags = new ArrayList<Comment.Tag>(userTags.length);
        for (final Tag t : userTags) {
            if (t == null) continue;
            Comment.Tag tag = new Comment.Tag(){

                @Override
                public String getTitle() {
                    return t.getTitle();
                }

                @Override
                public String getTagId() {
                    return t.getTagID();
                }
            };
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    protected com.adobe.cq.social.commons.Comment getComment() {
        return this.comment;
    }

    protected class ModeratorActionsImpl
    implements Comment.ModeratorActions {
        private boolean displayAllowButton = false;
        private boolean displayFlagButton = false;
        private boolean displayDenyButton = false;
        private boolean displayCloseButton = false;

        public ModeratorActionsImpl(com.adobe.cq.social.commons.Comment comment, CommentSystem cs, boolean userIsLoggedIn) {
            boolean commentApproved = comment.isApproved() || !cs.isModerated();
            this.displayFlagButton = userIsLoggedIn && !AbstractComment.this.isClosed && !AbstractComment.this.userIsOwner() && !comment.isSpam() && !comment.isFlaggedHidden() && !comment.isFlagged() && commentApproved && cs.allowsFlagging();
            this.displayAllowButton = AbstractComment.this.userIsModerator && !AbstractComment.this.isClosed && (comment.isSpam() || comment.isFlagged() || !commentApproved);
            this.displayDenyButton = AbstractComment.this.userIsModerator && !AbstractComment.this.isClosed && !comment.isSpam() && cs.allowsDeny();
            this.displayCloseButton = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && cs.allowsClose();
        }

        @Override
        public boolean getCanDeny() {
            return this.displayDenyButton;
        }

        @Override
        public boolean getUseFlagReasonList() {
            return AbstractComment.this.useFlagReasonList;
        }

        @Override
        public boolean getCanAllow() {
            return this.displayAllowButton;
        }

        @Override
        public boolean getCanFlag() {
            return this.displayFlagButton;
        }

        @Override
        public boolean getCanClose() {
            return this.displayCloseButton;
        }
    }

    protected class ModeratorStatusImpl
    implements Comment.ModeratorStatus {
        private final boolean flagged;
        private final boolean approved;
        private final boolean spam;

        public ModeratorStatusImpl(com.adobe.cq.social.commons.Comment comment, CommentSystem cs) {
            this.flagged = comment.isFlagged();
            this.approved = comment.isApproved() || !cs.isModerated();
            this.spam = comment.isSpam();
        }

        @Override
        @JsonProperty(value="isFlagged")
        public boolean isFlagged() {
            return this.flagged;
        }

        @Override
        @JsonProperty(value="isApproved")
        public boolean isApproved() {
            return this.approved;
        }

        @Override
        @JsonProperty(value="isSpam")
        public boolean isSpam() {
            return this.spam;
        }
    }
}

