/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.endpoints;

import com.adobe.cq.social.commons.annotation.Endpoint;
import com.adobe.cq.social.commons.annotation.Parameter;
import com.adobe.cq.social.commons.annotation.Parameters;
import com.adobe.cq.social.commons.client.endpoints.SocialOperationInfo;
import com.adobe.cq.social.ugcbase.AbstractSessionServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="AEM Social Communities OperationsServlet", description="This servlet returns the APIs that is supported by all social component endpoints")
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"com.adobe.cq.social.comments.client.endpoints.SocialOperationsServlet"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"social"}, propertyPrivate=false), @Property(name="sling.servlet.extensions", value={"api"}, propertyPrivate=false)})
@Reference(name="SocialOperationInfo", referenceInterface=SocialOperationInfo.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class SocialOperationsServlet
extends AbstractSessionServlet {
    private static final long serialVersionUID = -6564020190927800329L;
    protected final Map<String, List<SocialOperationInfo>> operationProviders = new ConcurrentHashMap<String, List<SocialOperationInfo>>(10);
    private static final Logger LOG = LoggerFactory.getLogger(SocialOperationsServlet.class);

    @Override
    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    @Override
    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        JSONWriter writer = new JSONWriter(response.getWriter());
        List<SocialOperationInfo> providers = this.getOperationProviders(resource);
        try {
            if (providers != null) {
                this.writeOperationProviders(writer, resource.getResourceType(), providers);
            } else {
                writer.object();
                writer.key("endpoints");
                writer.array();
                for (String type : this.operationProviders.keySet()) {
                    this.writeOperationProviders(writer, type, this.operationProviders.get(type));
                }
                writer.endArray();
                writer.endObject();
            }
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private List<SocialOperationInfo> getOperationProviders(Resource resource) {
        List<SocialOperationInfo> providers = this.operationProviders.get(resource.getResourceType());
        if (providers == null) {
            for (String type : this.operationProviders.keySet()) {
                if (!resource.isResourceType(type)) continue;
                return this.operationProviders.get(type);
            }
            return null;
        }
        return providers;
    }

    private void writeOperationProviders(JSONWriter out, String resourceType, List<SocialOperationInfo> providers) throws JSONException {
        out.object();
        out.key(resourceType);
        out.array();
        for (SocialOperationInfo provider : providers) {
            this.writeOperationInfo(out, provider);
        }
        out.endArray();
        out.endObject();
    }

    private void writeOperationInfo(JSONWriter out, SocialOperationInfo operation) throws JSONException {
        String example;
        Endpoint endpoint = operation.getEndpoint();
        out.object();
        out.key("name").value(endpoint.name());
        if (!StringUtils.isEmpty((CharSequence)endpoint.description())) {
            out.key("description").value(endpoint.description());
        }
        if (!StringUtils.isEmpty((CharSequence)(example = endpoint.example()))) {
            out.key("example").value(example);
        }
        this.writeParameters(out, operation.getRequestParameters());
        out.endObject();
    }

    private void writeParameters(JSONWriter out, Parameters parameters) throws JSONException {
        out.key("parameters");
        out.array();
        for (Parameter param : parameters.value()) {
            this.writeParameter(out, param);
        }
        out.endArray();
    }

    private void writeParameter(JSONWriter out, Parameter param) throws JSONException {
        out.object();
        out.key("name").value(param.name());
        out.key("value").value(param.value());
        out.key("required").value(param.required());
        if (StringUtils.isEmpty((CharSequence)param.description())) {
            out.key("description").value(param.description());
        }
        out.endObject();
    }

    protected void bindSocialOperationInfo(SocialOperationInfo operation) {
        Class<?> klass = operation.getClass();
        if (klass.isAnnotationPresent(Endpoint.class)) {
            Endpoint endpoint = operation.getEndpoint();
            Parameters parameters = operation.getRequestParameters();
            if (endpoint != null && parameters != null) {
                String type = endpoint.resourceType();
                List<SocialOperationInfo> providers = this.operationProviders.containsKey(type) ? this.operationProviders.get(type) : new ArrayList<SocialOperationInfo>();
                providers.add(operation);
                this.operationProviders.put(type, providers);
            }
        }
    }

    protected void unbindSocialOperationInfo(SocialOperationInfo operation) {
        String type;
        List<SocialOperationInfo> providers;
        Endpoint endpoint;
        Class<?> klass = operation.getClass();
        if (klass.isAnnotationPresent(Endpoint.class) && (endpoint = operation.getEndpoint()) != null && (providers = this.operationProviders.get(type = endpoint.resourceType())) != null) {
            providers.remove(operation);
            this.operationProviders.put(type, providers);
        }
    }
}

