/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.endpoints;

import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.ClientUtilityFactory;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponentFactoryManager;
import com.adobe.cq.social.ugcbase.AbstractSessionServlet;
import com.adobe.cq.social.ugcbase.SocialException;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.search.QueryBuilder;
import com.day.cq.wcm.api.components.ComponentContext;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="AEM Social Communities DefaultSocialGetServlet", description="This servlet serves the GET request for social components")
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"com.adobe.cq.social.comments.client.servlets.DefaultSocialGetServlet"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"social", "social.query", "index"}, propertyPrivate=false), @Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=false)})
public class DefaultSocialGetServlet
extends AbstractSessionServlet {
    protected static final String CONTENT_TYPE = "application/json";
    protected static final String ENCODING = "utf-8";
    protected static final Boolean DEFAULT_TIDY = Boolean.FALSE;
    private static final long serialVersionUID = 351915124629267812L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSocialGetServlet.class);
    private static final String TIDY = "tidy";
    private BundleContext bundleContext;
    @Reference
    protected SocialComponentFactoryManager srfMgr;
    @Reference
    protected QueryBuilder queryBuilder;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private XSSAPI xss;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private ClientUtilityFactory clientUtilFactory;
    public static final String DEFAULT_SELECTOR = "social";
    public static final String QUERY_SELECTOR = "social.query";
    public static final String INDEX_SELECTOR = "index";

    @Override
    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    @Override
    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        if (ResourceUtil.isNonExistingResource(resource)) {
            Resource ugcResource = request.getResourceResolver().getResource(this.socialUtils.resourceToUGCPath(resource));
            if (ugcResource == null) {
                response.setStatus(404);
                return;
            }
            String bareResourcePath = resource.getPath();
            bareResourcePath = StringUtils.removeEnd((String)bareResourcePath, (String)("." + request.getRequestPathInfo().getExtension()));
            bareResourcePath = StringUtils.removeEnd((String)bareResourcePath, (String)("." + request.getRequestPathInfo().getSelectorString()));
            resource = new SyntheticResource(request.getResourceResolver(), bareResourcePath, ugcResource.getResourceType());
            SlingHttpServletRequestWrapper wrappingRequest = new SlingHttpServletRequestWrapper(request);
            RequestDispatcher dispatcher = request.getRequestDispatcher(resource);
            wrappingRequest.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, true);
            dispatcher.include((ServletRequest)wrappingRequest, (ServletResponse)response);
            return;
        }
        boolean tidy = request.getParameter(TIDY) != null ? Boolean.parseBoolean(request.getParameter(TIDY)) : DEFAULT_TIDY;
        SocialComponentFactory factory = this.srfMgr.getSocialComponentFactory(resource);
        try {
            if (factory == null) {
                BaseSocialComponent socialComponent = new BaseSocialComponent(resource, this.getClientUtils(request));
                this.sendResponse(socialComponent, response, request, tidy);
            } else {
                SocialComponent socialComponent = factory.getSocialComponent(resource, request);
                if (socialComponent != null) {
                    this.sendResponse(socialComponent, response, request, tidy);
                } else {
                    response.setStatus(204);
                }
            }
        }
        catch (SocialException e) {
            LOG.warn("Could not get a SCF component for request.", (Throwable)e);
            response.setStatus(404);
        }
    }

    private void sendResponse(SocialComponent resource, SlingHttpServletResponse response, SlingHttpServletRequest request, boolean tidy) throws IOException {
        this.setResponseHeaders(response, request);
        this.writeResponse(resource, response, request, tidy);
    }

    protected void writeResponse(SocialComponent resource, SlingHttpServletResponse response, SlingHttpServletRequest request, boolean tidy) throws IOException {
        response.getWriter().write(resource.toJSONString(tidy));
    }

    protected void setResponseHeaders(SlingHttpServletResponse response, SlingHttpServletRequest request) {
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(ENCODING);
    }

    protected ClientUtilities getClientUtils(SlingHttpServletRequest request) {
        return this.clientUtilFactory.getClientUtilities(this.xss, request, this.socialUtils);
    }

    protected void activate(org.osgi.service.component.ComponentContext context) {
        this.bundleContext = context.getBundleContext();
    }

    protected void bindSrfMgr(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.srfMgr = socialComponentFactoryManager;
    }

    protected void unbindSrfMgr(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.srfMgr == socialComponentFactoryManager) {
            this.srfMgr = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }
}

