/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.endpoints;

import com.adobe.cq.social.commons.client.endpoints.Operation;
import com.adobe.cq.social.commons.client.endpoints.OperationException;
import com.adobe.cq.social.commons.client.endpoints.OperationExtension;
import com.adobe.cq.social.commons.client.endpoints.OperationService;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationService<T extends OperationExtension, U extends Operation, S>
implements OperationService<T, U, S> {
    protected final Map<U, SortedSet<T>> extensionProviders = new ConcurrentHashMap<U, SortedSet<T>>(10);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOperationService.class);

    @Override
    public synchronized void addOperationExtension(T extension) {
        for (Operation op : extension.getOperationsToHookInto()) {
            Operation operation = op;
            SortedSet<Object> providers = this.extensionProviders.containsKey(operation) ? this.extensionProviders.get(operation) : Collections.synchronizedSortedSet(new TreeSet(new Comparator<T>(){

                @Override
                public int compare(T a, T b) {
                    return a.getOrder() - b.getOrder();
                }
            }));
            providers.add(extension);
            this.extensionProviders.put(operation, providers);
        }
    }

    @Override
    public synchronized void removeOperationExtension(T extension) {
        for (Operation op : extension.getOperationsToHookInto()) {
            Operation operation = op;
            if (!this.extensionProviders.containsKey(operation)) continue;
            SortedSet<T> providers = this.extensionProviders.get(operation);
            providers.remove(extension);
            this.extensionProviders.put(operation, providers);
        }
    }

    @Override
    public void performBeforeActions(U operation, Session session, Resource resource, Map<String, Object> requestParameters) throws OperationException {
        if (this.extensionProviders.containsKey(operation)) {
            for (OperationExtension extension : this.extensionProviders.get(operation)) {
                extension.beforeAction((Operation)operation, session, resource, requestParameters);
            }
        }
    }

    @Override
    public void performAfterActions(U operation, Session session, S component, Map<String, Object> requestParameters) throws OperationException {
        if (this.extensionProviders.containsKey(operation)) {
            for (OperationExtension extension : this.extensionProviders.get(operation)) {
                extension.afterAction((Operation)operation, session, component, requestParameters);
            }
        }
    }

    protected Map<String, Object> getValueMapFromRequest(SlingHttpServletRequest request) throws RepositoryException {
        RequestParameterMap params = request.getRequestParameterMap();
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        for (String key : params.keySet()) {
            Object value;
            RequestParameter[] values = (RequestParameter[])params.get(key);
            if (values.length <= 0) continue;
            if (!key.equals("file")) {
                value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                map.put(key, value);
                continue;
            }
            value = request.getRequestParameters(key);
            map.put(key, value);
        }
        return map;
    }
}

