/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.AbstractSocialComponentFactory;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.impl.UserImpl;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.granite.security.user.UserPropertiesManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

@Component(label="AEM Social Communities UserSocialComponentFactory")
@Service
public class UserSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private ScoringService scoring;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new UserImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getUserPropertiesManager(resource), this.scoring);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return new UserImpl(resource, this.getClientUtilities(request), this.getUserPropertiesManager(resource), this.scoring);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        return new UserImpl(resource, clientUtils, this.getUserPropertiesManager(resource), this.scoring);
    }

    protected UserPropertiesManager getUserPropertiesManager(Resource resource) {
        return resource.getResourceResolver().adaptTo(UserPropertiesManager.class);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/commons/components/author";
    }

    protected ScoringService getScoringService() {
        return this.scoring;
    }

    protected void bindScoring(ScoringService scoringService) {
        this.scoring = scoringService;
    }

    protected void unbindScoring(ScoringService scoringService) {
        if (this.scoring == scoringService) {
            this.scoring = null;
        }
    }
}

