/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.CollectionSortedOrder;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseQueryRequestInfo
implements QueryRequestInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BaseQueryRequestInfo.class);
    private final boolean isQueryRequest;
    private final Map<String, String[]> predicates;
    private CollectionPagination pagination;
    private CollectionSortedOrder order = CollectionSortedOrder.DEFAULT_ORDER;
    private List<String> sortBy;
    public static QueryRequestInfo DEFAULT_QUERY_REQUEST = new BaseQueryRequestInfo();
    private static String PN_QUERY_FILTER = "filter";

    private BaseQueryRequestInfo() {
        this.pagination = CollectionPagination.DEFAULT_PAGINATION;
        this.isQueryRequest = false;
        this.predicates = Collections.emptyMap();
    }

    public BaseQueryRequestInfo(SlingHttpServletRequest request) {
        this.pagination = this.getPaginationFromRequest(request);
        this.isQueryRequest = this.isQueryRequest(request);
        this.predicates = this.isQueryRequest ? request.getParameterMap() : Collections.emptyMap();
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination, CollectionSortedOrder order) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
        this.order = order;
    }

    public BaseQueryRequestInfo(boolean isQueryRequest, Map<String, String[]> predicates, CollectionPagination pagination, CollectionSortedOrder order, List<String> sortBy) {
        this.isQueryRequest = isQueryRequest;
        this.predicates = predicates;
        this.pagination = pagination;
        this.order = order;
        this.sortBy = sortBy;
    }

    protected CollectionPagination getPaginationFromRequest(SlingHttpServletRequest request) {
        String[] selectors;
        if (request != null && (selectors = (String[])ArrayUtils.removeElement((Object[])request.getRequestPathInfo().getSelectors(), (Object)"social")) != null && selectors.length >= 2) {
            try {
                int maxIndex = selectors.length - 1;
                int offset = Integer.parseInt(selectors[maxIndex - 1]);
                int size = Integer.parseInt(selectors[maxIndex]);
                String selectedIndex = null;
                if (StringUtils.equals((CharSequence)selectors[0], (CharSequence)"index")) {
                    selectedIndex = selectors[1];
                }
                CollectionPagination pagination = new CollectionPagination(offset, size, 0, selectedIndex);
                return pagination;
            }
            catch (NumberFormatException e) {
                LOG.error("Bad pagination request to " + request.getPathInfo(), (Throwable)e);
            }
        }
        return CollectionPagination.DEFAULT_PAGINATION;
    }

    private boolean isQueryRequest(SlingHttpServletRequest request) {
        boolean query;
        RequestPathInfo info = request.getRequestPathInfo();
        String selector = info.getSelectorString();
        boolean bl = query = selector != null && selector.contains("social.query");
        if (!query) {
            query = request.getParameterMap().containsKey(PN_QUERY_FILTER);
        }
        return query;
    }

    @Override
    public boolean isQuery() {
        return this.isQueryRequest;
    }

    @Override
    public Map<String, String[]> getPredicates() {
        return this.predicates;
    }

    @Override
    public CollectionPagination getPagination() {
        return this.pagination;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public List<String> getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortOrder(CollectionSortedOrder order) {
        this.order = order;
    }

    @Override
    public CollectionSortedOrder getSortOrder() {
        return this.order;
    }
}

