/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.User;
import com.adobe.cq.social.commons.client.impl.UserImpl;
import com.adobe.cq.social.scoring.api.ScoringException;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUser
extends BaseSocialComponent
implements User {
    private static final String BADGE_IMG_PATH = "/jcr:content/image/file/jcr:content";
    private static final String RULE_SEPARATOR = "#";
    private static final String PN_MAPPINGS = "mappings";
    private static final String BADGE_PATH = "/jcr:content/badge";
    private static final String PN_NUMBER_OF_POSTS = "numberOfPosts";
    private static final String FORUM_PATH = "forum";
    private static final String HTML_EXT = ".html";
    private static final String PROFILE_EXT = ".form.html";
    private static final String PROFILE_PATH = "profile";
    private static final String SOCIAL_AUTHORS_PREFIX = "/social/authors/";
    private final UserProperties userProps;
    private static final Logger LOG = LoggerFactory.getLogger(UserImpl.class);
    static final String DEFAULT_AVATAR_PATH = "/etc/designs/default/images/social/avatar.png";
    private String name;
    private String avatarPath;
    private String userId;
    private final ClientUtilities clientUtils;
    private String largeAvatarPath;
    private final ScoringService scoring;

    public AbstractUser(Resource resource, ClientUtilities clientUtils, UserPropertiesManager upm, ScoringService scoring) {
        super(resource, clientUtils);
        this.clientUtils = clientUtils;
        this.scoring = scoring;
        try {
            this.userProps = this.getUserProperties(resource, upm);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get userId from resource ", (Throwable)e);
            throw new RuntimeException("Unable to find userproperties for " + resource.getPath());
        }
        if (null == this.userProps) {
            LOG.error("Unable to get userId from resource ", (Object)resource.getPath());
            this.setUpDefaults();
        } else {
            String authorId = this.userProps.getAuthorizableID();
            String avatarpath = DEFAULT_AVATAR_PATH;
            String largeAvatarpath = DEFAULT_AVATAR_PATH;
            String usrName = "Anonymous";
            this.userId = this.userProps.getAuthorizableID();
            if (authorId != null && authorId.length() > 0) {
                avatarpath = clientUtils.getSocialUtils().getAvatar(this.userProps, DEFAULT_AVATAR_PATH);
                largeAvatarpath = clientUtils.getSocialUtils().getAvatar(this.userProps, DEFAULT_AVATAR_PATH, SocialUtils.AVATAR_SIZE.FOURTY_EIGHT);
                try {
                    usrName = this.userProps.getDisplayName();
                }
                catch (RepositoryException e) {
                    LOG.error("Unable to get username for ", (Object)this.userId);
                }
            }
            this.avatarPath = avatarpath;
            this.largeAvatarPath = largeAvatarpath;
            this.name = usrName;
        }
    }

    private void setUpDefaults() {
        this.userId = "anonymous";
        this.avatarPath = "";
        this.largeAvatarPath = "";
        this.name = "Unknown";
    }

    private UserProperties getUserProperties(Resource resource, UserPropertiesManager upm) throws RepositoryException {
        String resourcePath;
        if (StringUtils.equals((CharSequence)"social/commons/components/author", (CharSequence)resource.getResourceType()) && StringUtils.contains((CharSequence)(resourcePath = resource.getPath()), (CharSequence)SOCIAL_AUTHORS_PREFIX)) {
            String userId = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            return upm.getUserProperties(userId, PROFILE_PATH);
        }
        throw new RuntimeException("Unable to find userproperties for " + resource.getPath());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAvatarUrl() {
        if (this.clientUtils == null) {
            return this.avatarPath;
        }
        return this.clientUtils.externalLink(this.avatarPath, false);
    }

    @Override
    public String getLargeAvatarUrl() {
        if (this.clientUtils == null) {
            return this.largeAvatarPath;
        }
        return this.clientUtils.externalLink(this.largeAvatarPath, false);
    }

    @Override
    @JsonIgnore
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getProfileUrl() {
        String resourceAuthorPath;
        if (this.userProps == null) {
            return "";
        }
        String socialProfilePage = this.clientUtils.getSocialProfilePath();
        try {
            resourceAuthorPath = this.userProps.getNode().getPath();
        }
        catch (RepositoryException e) {
            LOG.error("Error retrieving profile url for " + this.userProps.getAuthorizableID(), (Throwable)e);
            return null;
        }
        String url = socialProfilePage != null && resourceAuthorPath != null ? resourceAuthorPath + PROFILE_EXT + socialProfilePage : "";
        return this.clientUtils.externalLink(url, false) + HTML_EXT;
    }

    @Override
    public Long getNumberOfPosts() {
        Resource profileResource;
        if (this.userProps == null) {
            return 0L;
        }
        try {
            profileResource = this.userProps.getResource(FORUM_PATH);
        }
        catch (RepositoryException e) {
            LOG.error("Error retrieving post count for " + this.userProps.getAuthorizableID(), (Throwable)e);
            return 0L;
        }
        if (null != profileResource) {
            ValueMap props = ResourceUtil.getValueMap(profileResource);
            return props.get(PN_NUMBER_OF_POSTS, 0L);
        }
        return 0L;
    }

    @Override
    public List<User.Badge> getBadges() {
        if (this.userProps == null) {
            return null;
        }
        Page badgeMapContainingPage = this.clientUtils.getContainingPage("");
        if (badgeMapContainingPage == null) {
            return null;
        }
        Resource badgeMap = this.resource.getResourceResolver().getResource(badgeMapContainingPage.getPath() + BADGE_PATH);
        if (badgeMap == null) {
            return null;
        }
        ValueMap badgePageProperties = badgeMap.adaptTo(ValueMap.class);
        ArrayList<User.Badge> badges = new ArrayList<User.Badge>();
        String[] rules = (String[])badgePageProperties.get(PN_MAPPINGS, String[].class);
        if (rules == null) {
            return null;
        }
        for (String rule : rules) {
            String[] segmentBadgeMap = rule.split(RULE_SEPARATOR);
            if (segmentBadgeMap == null) continue;
            String segmentPath = segmentBadgeMap[0];
            String badgePath = segmentBadgeMap[1];
            try {
                if (!this.scoring.resolveScoringSegment(segmentPath, this.userId)) continue;
                final Page badgePage = this.clientUtils.getContainingPage(badgePath);
                badges.add(new User.Badge(){

                    @Override
                    public String getTitle() {
                        return badgePage.getTitle();
                    }

                    @Override
                    public String getImageUrl() {
                        return AbstractUser.this.clientUtils.externalLink(badgePage.getPath() + AbstractUser.BADGE_IMG_PATH, false);
                    }
                });
            }
            catch (ScoringException e) {
                LOG.error("Unable to find scores for user " + this.userProps.getAuthorizableID(), (Throwable)e);
            }
        }
        return badges;
    }

    protected UserProperties getUserProperties() {
        return this.userProps;
    }
}

