/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponentFactoryManager;
import com.adobe.cq.social.commons.client.api.User;
import com.adobe.cq.social.commons.client.impl.SocialComponentFactoryManagerImpl;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientUtility
implements ClientUtilities {
    private static final String COMMENT_EXT = ".social.json";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientUtility.class);
    private final XSSAPI xss;
    private final SlingHttpServletRequest request;
    private final SocialUtils socialUtils;
    private final Map<String, Object> activeConfigs;
    private final SlingSettingsService slingSettingsService;
    private final ResourceResolver resolver;
    private static final String AN_CACHED_CLOUD_CONFIGS = "social:cachedCloudConfigs";
    private static final String KN_STORAGE_CLOUD_CONFIG = "social:storageCloudConfig";
    private static final String KN_MT_CLOUD_CONFIG = "granite:mtcloudconfig";

    public AbstractClientUtility(XSSAPI xss, SlingHttpServletRequest request, SocialUtils socialUtils, SlingSettingsService slingSettingsService) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null when getting client utilities. This can be created with a resolver instead.");
        }
        this.xss = xss;
        this.request = request;
        this.resolver = request.getResourceResolver();
        this.socialUtils = socialUtils;
        this.slingSettingsService = slingSettingsService;
        this.activeConfigs = request != null && request.getAttribute(AN_CACHED_CLOUD_CONFIGS) != null ? (Map<Object, Object>)request.getAttribute(AN_CACHED_CLOUD_CONFIGS) : new HashMap<String, Object>();
    }

    public AbstractClientUtility(XSSAPI xss, ResourceResolver resolver, SocialUtils socialUtils, SlingSettingsService slingSettingsService) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver cannot be null when getting client utilities.");
        }
        this.xss = xss;
        this.request = null;
        this.resolver = resolver;
        this.socialUtils = socialUtils;
        this.slingSettingsService = slingSettingsService;
        this.activeConfigs = this.request != null && this.request.getAttribute(AN_CACHED_CLOUD_CONFIGS) != null ? (Map<Object, Object>)this.request.getAttribute(AN_CACHED_CLOUD_CONFIGS) : new HashMap<String, Object>();
    }

    public static void setOutputIndenting(ObjectMapper objectMapper, boolean indent) {
        if (indent) {
            if (!objectMapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            }
        } else if (objectMapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    @Override
    public String externalLink(String path) {
        return this.externalLink(path, true);
    }

    @Override
    public String externalLink(String path, Boolean needExtension) {
        Page page;
        String commentExt = needExtension != false ? COMMENT_EXT : "";
        String tempPath = path;
        Resource resourceToCheck = null;
        if (this.request != null) {
            resourceToCheck = this.request.getResource();
        } else if (this.resolver != null && this.resolver.isLive() && (page = this.socialUtils.getContainingPage(this.resolver.resolve(tempPath))) != null) {
            resourceToCheck = page.getContentResource();
        }
        if (resourceToCheck == null) {
            LOG.debug("Could not find a resource based on the requested path {}. Returning the path and extension.", (Object)tempPath);
            return tempPath + commentExt;
        }
        if (!tempPath.startsWith("/content/usergenerated") && this.getMTCloudConfig(resourceToCheck) != null) {
            String searchString;
            String pathLocale;
            String resourceToCheckLocale = this.getPageLanguage(this.resolver, resourceToCheck);
            if (this.resolver != null && this.resolver.isLive() && resourceToCheckLocale != null && (pathLocale = this.getPageLanguage(this.resolver, this.resolver.resolve(tempPath))) != null && !StringUtils.equals((CharSequence)resourceToCheckLocale, (CharSequence)pathLocale) && StringUtils.contains((CharSequence)tempPath, (CharSequence)(searchString = "/" + pathLocale + "/"))) {
                LOG.debug("Replacing locale code in path: {}.  Looking for {}", (Object)tempPath, (Object)searchString);
                String replaceString = "/" + resourceToCheckLocale + "/";
                tempPath = StringUtils.replaceOnce((String)tempPath, (String)searchString, (String)replaceString);
            }
        }
        Externalizer externalizer = null;
        ResourceResolver resolver = this.getResourceResolver();
        externalizer = resolver.adaptTo(Externalizer.class);
        if (externalizer != null) {
            String externalizerPath = tempPath;
            String pathRemainder = "";
            if (tempPath.startsWith("/content/usergenerated")) {
                externalizerPath = "/content/usergenerated";
                pathRemainder = tempPath.substring("/content/usergenerated".length());
            }
            String externalURL = this.slingSettingsService.getRunModes().contains("author") ? externalizer.authorLink(resolver, externalizerPath) + pathRemainder + commentExt : externalizer.publishLink(resolver, externalizerPath) + pathRemainder + commentExt;
            try {
                return this.getRootBasedURL(externalURL);
            }
            catch (MalformedURLException e) {
                LOG.debug("URL is invalid.", (Throwable)e);
                return path + commentExt;
            }
        }
        LOG.debug("Unable to get an Externalizer.  Returning path and extension.  {} + {}", (Object)path, (Object)commentExt);
        return tempPath + commentExt;
    }

    private String getRootBasedURL(String url) throws MalformedURLException {
        URL startURL = new URL(url);
        String HOST_CHECK_HEADER = "origin";
        if (StringUtils.startsWithIgnoreCase((CharSequence)startURL.getProtocol(), (CharSequence)"http")) {
            if (this.request != null && !StringUtils.isEmpty((CharSequence)this.request.getHeader("origin"))) {
                try {
                    String headerToCheck = this.request.getHeader("origin");
                    URL refererURL = new URL(headerToCheck);
                    if (!StringUtils.equals((CharSequence)this.getCORPath(refererURL), (CharSequence)this.getCORPath(startURL))) {
                        if (!StringUtils.isEmpty((CharSequence)this.request.getHeader("Host"))) {
                            String noScheme = this.stripSchemeHostAndPort(startURL);
                            return startURL.getProtocol() + "://" + this.request.getHeader("Host") + "/" + StringUtils.substringAfter((String)noScheme, (String)"/");
                        }
                        return url;
                    }
                }
                catch (MalformedURLException e) {
                    LOG.warn("Could not detect anywhere component because referer url is bad: {}", (Object)this.request.getHeader("referer"), (Object)e);
                }
            }
            String rootBased = this.stripSchemeHostAndPort(startURL);
            return rootBased;
        }
        return url;
    }

    private String stripSchemeHostAndPort(URL url) {
        return StringUtils.removeStart((String)url.toString(), (String)(url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort())));
    }

    private String getCORPath(URL url) {
        return url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
    }

    @Override
    public String getRequestExtension() {
        if (this.request != null) {
            return this.request.getRequestPathInfo().getExtension();
        }
        return null;
    }

    @Override
    public String filterHTML(String valueToBeFiltered) {
        if (this.xss != null) {
            return this.xss.filterHTML(valueToBeFiltered);
        }
        return valueToBeFiltered;
    }

    @Override
    public SocialComponentFactoryManager getSocialComponentFactoryManager() {
        return SocialComponentFactoryManagerImpl.getInstance();
    }

    @Override
    public SocialUtils getSocialUtils() {
        return this.socialUtils;
    }

    @Override
    public String getAuthorizedUserId() {
        if (this.request != null) {
            Session session = this.request.getResourceResolver().adaptTo(Session.class);
            return session.getUserID();
        }
        return null;
    }

    @Override
    public boolean userIsAnonymous() {
        String userId = this.getAuthorizedUserId();
        return userId == null || userId.equalsIgnoreCase("Anonymous");
    }

    @Override
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public String getSocialProfilePath() {
        if (this.request == null || this.socialUtils == null) {
            return null;
        }
        return WCMUtils.getInheritedProperty(this.socialUtils.getContainingPage(this.request.getResource()), this.request.getResourceResolver(), "cq:socialProfilePage");
    }

    @Override
    public Page getContainingPage(String path) {
        if (this.request == null || this.socialUtils == null) {
            return null;
        }
        String pathToFind = StringUtils.startsWith((CharSequence)path, (CharSequence)"/") ? path : this.request.getResource().getPath() + "/" + path;
        return this.socialUtils.getContainingPage(this.request.getResourceResolver().resolve(pathToFind));
    }

    @Override
    public Page getPage(String pathToPage) {
        Page p = null;
        if (this.socialUtils != null) {
            ResourceResolver resolver = this.getResourceResolver();
            p = this.socialUtils.getPage(pathToPage, resolver);
        }
        return null;
    }

    @Override
    public User getUser(String userId, ResourceResolver resolver) {
        SocialComponentFactory scf;
        SyntheticResource authorResource = new SyntheticResource(resolver, "/social/authors/" + userId, "social/commons/components/author");
        SocialComponentFactoryManager scfMgr = this.getSocialComponentFactoryManager();
        if (scfMgr != null && (scf = scfMgr.getSocialComponentFactory(authorResource)) != null) {
            return (User)scf.getSocialComponent(authorResource, this, null);
        }
        return null;
    }

    @Override
    public Configuration getStorageCloudConfig(Resource resource) {
        if (!this.activeConfigs.containsKey(KN_STORAGE_CLOUD_CONFIG)) {
            Configuration config = this.socialUtils.getStorageCloudServiceConfig(resource);
            this.activeConfigs.put(KN_STORAGE_CLOUD_CONFIG, config);
            if (this.request != null) {
                this.request.setAttribute(AN_CACHED_CLOUD_CONFIGS, this.activeConfigs);
            }
        }
        return (Configuration)this.activeConfigs.get(KN_STORAGE_CLOUD_CONFIG);
    }

    @Override
    public MachineTranslationCloudConfig getMTCloudConfig(Resource resource) {
        if (!this.activeConfigs.containsKey(KN_MT_CLOUD_CONFIG) && this.resolver != null) {
            MachineTranslationUtil mtu = this.resolver.adaptTo(MachineTranslationUtil.class);
            if (mtu != null) {
                MachineTranslationCloudConfig mtcc = mtu.getAppliedMachineTranslationCloudConfigs(resource);
                this.activeConfigs.put(KN_MT_CLOUD_CONFIG, mtcc);
                if (this.request != null) {
                    this.request.setAttribute(AN_CACHED_CLOUD_CONFIGS, this.activeConfigs);
                }
            } else {
                LOG.debug("MachineTranslationUtil was null");
            }
        }
        return (MachineTranslationCloudConfig)this.activeConfigs.get(KN_MT_CLOUD_CONFIG);
    }

    private String getPageLanguage(ResourceResolver resourceResolver, Resource resource) {
        Page containingPage;
        if (resourceResolver == null || resource == null) {
            LOG.warn("resourceResolver or resource was null!");
            return null;
        }
        PageManager pm = resourceResolver.adaptTo(PageManager.class);
        Page page = containingPage = pm != null ? pm.getContainingPage(resource) : null;
        if (containingPage == null) {
            return null;
        }
        return containingPage.getParent(1).getLanguage(false).getLanguage();
    }

    protected ResourceResolver getResourceResolver() {
        if (this.resolver != null) {
            return this.resolver;
        }
        return this.request.getResourceResolver();
    }

    protected XSSAPI getXss() {
        return this.xss;
    }

    protected SlingSettingsService getSlingSettingsService() {
        return this.slingSettingsService;
    }
}

