/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class CommentUtil {
    public static boolean isPending(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && CommentUtil.isSystemModerated(component) && "".equals(CommentUtil.getProperty(resource, "approved", ""));
    }

    public static boolean isApproved(Resource resource, Resource component) {
        return !CommentUtil.isSpam(resource) && (!CommentUtil.isSystemModerated(component) || CommentUtil.getProperty(resource, "approved", false) != false);
    }

    public static boolean isSpam(Resource resource) {
        return CommentUtil.getProperty(resource, "isSpam", false);
    }

    public static boolean isFlagged(Resource resource) {
        return CommentUtil.getProperty(resource, "isFlagged", false);
    }

    public static boolean isClosed(Resource resource) {
        return CommentUtil.getProperty(resource, "isClosed", false);
    }

    public static boolean isFlaggedHidden(Resource resource) {
        return CommentUtil.getProperty(resource, "isFlaggedHidden", false);
    }

    public static boolean isSystemModerated(Resource component) {
        return CommentUtil.getProperty(component, "moderateComments", false);
    }

    public static boolean isSystemClosed(Resource component) {
        return CommentUtil.getProperty(component, "closed", false);
    }

    public static <T> T getProperty(Resource resource, String name, T defaultValue) {
        try {
            return resource.adaptTo(ValueMap.class).get(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isAllowVoting(Resource component) {
        return CommentUtil.getProperty(component, "allowVoting", false);
    }

    public static String getVotingType(Resource component) {
        return CommentUtil.getDesignConfig(component, "votingType", "social/tally/components/hbs/voting");
    }

    public static String getVotingRoot(Resource component) {
        return CommentUtil.getDesignConfig(component, "votingRoot", "voting");
    }

    public static <T> T getDesignConfig(Resource component, String configName, T defaultValue) {
        ResourceResolver resolver = component.getResourceResolver();
        Designer commentDesign = resolver.adaptTo(Designer.class);
        if (null != commentDesign) {
            Style style = null;
            try {
                style = commentDesign.getStyle(component);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (null != style) {
                return style.get(configName, defaultValue);
            }
        }
        return defaultValue;
    }
}

