/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.CommentSystem;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.workflow.api.WcmWorkflowService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Activate Comment"})
public class ActivateCommentProcess
implements WorkflowProcess {
    private static final String FORWARD_REPLICATED = "forwardReplicated";
    private static final String SLING_FOLDER = "sling:Folder";
    private static final ReplicationActionType REPLICATION_TYPE = ReplicationActionType.ACTIVATE;
    private static final Logger log = LoggerFactory.getLogger(ActivateCommentProcess.class);
    private static final String TYPE_JCR_PATH = "JCR_PATH";
    private static final String TYPE_JCR_UUID = "JCR_UUID";
    @Reference
    private Replicator replicator;
    @Reference
    private WcmWorkflowService wcmWfService;
    @Reference
    private WorkflowService wfService;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory rrf;
    private Session admin;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session participantSession = null;
        Session replicationSession = null;
        try {
            String approverId;
            Session session = workflowSession.getSession();
            if (this.replicateAsParticipant(args) && (approverId = this.resolveParticipantId(workItem, workflowSession)) != null) {
                participantSession = this.getParticipantSession(approverId, workflowSession);
            }
            replicationSession = participantSession != null ? participantSession : session;
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String)data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            } else if (data.getPayload() != null && type.equals(TYPE_JCR_UUID)) {
                Node node = session.getNodeByIdentifier((String)data.getPayload());
                path = node.getPath();
            }
            ReplicationOptions opts = null;
            String rev = (String)((Object)data.getMetaDataMap().get("resourceVersion", String.class));
            if (rev != null) {
                opts = new ReplicationOptions();
                opts.setRevision(rev);
            }
            if (path != null) {
                List<String> paths = this.getPaths(path);
                for (String aPath : paths) {
                    if (this.canReplicate(replicationSession, aPath)) {
                        if (opts != null) {
                            this.replicator.replicate(replicationSession, REPLICATION_TYPE, aPath, opts);
                            continue;
                        }
                        this.replicator.replicate(replicationSession, REPLICATION_TYPE, aPath);
                        continue;
                    }
                    log.debug(session.getUserID() + " is not allowed to replicate " + "this page/asset " + aPath + ". Issuing request for 'replication");
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    ((Dictionary)properties).put("path", aPath);
                    ((Dictionary)properties).put("replicationType", (Object)((Object)REPLICATION_TYPE));
                    ((Dictionary)properties).put("userId", session.getUserID());
                    Event event = new Event("com/day/cq/wcm/workflow/req/for/activation", properties);
                    this.eventAdmin.sendEvent(event);
                }
            } else {
                log.warn("Cannot activate page or asset because path is null for this workitem: " + workItem.toString());
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
        catch (ReplicationException e) {
            throw new WorkflowException(e);
        }
        catch (LoginException e) {
            throw new WorkflowException(e);
        }
        finally {
            if (participantSession != null && participantSession.isLive()) {
                participantSession.logout();
                participantSession = null;
            }
        }
    }

    private boolean replicateAsParticipant(MetaDataMap args) {
        String processArgs = (String)((Object)args.get(Arguments.PROCESS_ARGS.getArgumentName(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            String[] arguments;
            for (String argument : arguments = processArgs.split(",")) {
                String[] split = argument.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                String value = split[1];
                if (!key.equalsIgnoreCase(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName())) continue;
                return Boolean.parseBoolean(value);
            }
            return false;
        }
        return args.get(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName(), Boolean.FALSE);
    }

    private Session getParticipantSession(String participantId, WorkflowSession workflowSession) {
        try {
            return workflowSession.getSession().impersonate((Credentials)new SimpleCredentials(participantId, new char[0]));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private String resolveParticipantId(WorkItem workItem, WorkflowSession workflowSession) {
        List<Object> history = new ArrayList();
        try {
            history = workflowSession.getHistory(workItem.getWorkflow());
            for (int index = history.size() - 1; index >= 0; --index) {
                HistoryItem previous = (HistoryItem)history.get(index);
                String type = previous.getWorkItem().getNode().getType();
                if (type == null || !type.equals("PARTICIPANT") && !type.equals("DYNAMIC_PARTICIPANT")) continue;
                return previous.getUserId();
            }
            return null;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    protected List<String> getPaths(String path) throws PathNotFoundException, RepositoryException, LoginException {
        ArrayList<String> paths = new ArrayList<String>();
        this.addRootPath(paths, path);
        paths.add(path);
        paths.addAll(this.getCommentChildren(path));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRootPath(List<String> paths, String commentPath) throws LoginException {
        ResourceResolver resolver = this.rrf.getAdministrativeResourceResolver(null);
        try {
            Resource resource = resolver.getResource(commentPath);
            if (resource == null) {
                log.error("Could not retrieve comment resource: {}", (Object)commentPath);
                return;
            }
            CommentSystem cs = resource.adaptTo(CommentSystem.class);
            if (cs == null) {
                log.error("Could not adapt resource to comment system: {}", (Object)commentPath);
                return;
            }
            String rootPath = cs.getRootPath();
            paths.add(rootPath);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    protected List<String> getCommentChildren(String parentComment) throws RepositoryException {
        ArrayList<String> children = new ArrayList<String>();
        Node parent = (Node)this.admin.getItem(parentComment);
        NodeIterator nIt = parent.getNodes();
        while (nIt.hasNext()) {
            Node child = nIt.nextNode();
            if (!"attachments".equals(child.getName()) || !child.isNodeType(SLING_FOLDER) || child.hasProperty(FORWARD_REPLICATED)) continue;
            children.add(child.getPath());
            child.setProperty(FORWARD_REPLICATED, Calendar.getInstance());
            child.getSession().save();
            children.addAll(this.getFolderContents(child));
        }
        return children;
    }

    protected List<String> getFolderContents(Node folder) throws RepositoryException {
        ArrayList<String> children = new ArrayList<String>();
        NodeIterator nIt = folder.getNodes();
        while (nIt.hasNext()) {
            Node child = nIt.nextNode();
            children.add(child.getPath());
        }
        return children;
    }

    protected boolean canReplicate(Session session, String path) throws AccessDeniedException {
        try {
            AccessControlManager acMgr = session.getAccessControlManager();
            return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.admin = this.repository.loginAdministrative(null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null) {
            this.admin.logout();
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindWcmWfService(WcmWorkflowService wcmWorkflowService) {
        this.wcmWfService = wcmWorkflowService;
    }

    protected void unbindWcmWfService(WcmWorkflowService wcmWorkflowService) {
        if (this.wcmWfService == wcmWorkflowService) {
            this.wcmWfService = null;
        }
    }

    protected void bindWfService(WorkflowService workflowService) {
        this.wfService = workflowService;
    }

    protected void unbindWfService(WorkflowService workflowService) {
        if (this.wfService == workflowService) {
            this.wfService = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    private static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        REPLICATE_AS_PARTICIPANT("replicateAsParticipant");

        private final String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }
    }
}

