/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.calendar.client.api;

import com.adobe.cq.social.calendar.client.api.DateRangeFilter;
import com.adobe.cq.social.calendar.client.impl.CalendarImpl;
import com.adobe.cq.social.calendar.client.impl.CalendarQueryRequestInfoImpl;
import com.adobe.cq.social.calendar.client.impl.DateRangeFilterImpl;
import com.adobe.cq.social.commons.client.api.AbstractSocialComponentFactory;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.day.cq.commons.date.DateUtil;
import com.day.cq.commons.date.InvalidDateException;
import java.util.Calendar;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="AEM Social Communities Calendar SocialComponent Factory")
@Service(value={SocialComponentFactory.class})
public class CalendarSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarSocialComponentFactory.class);
    private static final DateUtil dateUtil = new DateUtil();

    @Override
    public String getSupportedResourceType() {
        return "social/calendar/components/hbs/calendar";
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new CalendarImpl(resource, this.getClientUtilities(resource.getResourceResolver()));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        try {
            if (request != null) {
                return new CalendarImpl(resource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.getDateRangeFromRequest(request));
            }
            return new CalendarImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getQueryRequestInfo(request), this.getDateRangeFromRequest(request));
        }
        catch (InvalidDateException e) {
            LOG.error("Bad date filter specification to " + request.getPathInfo(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.error("Bad pagination request to " + request.getPathInfo(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected QueryRequestInfo getQueryRequestInfo(SlingHttpServletRequest request) {
        if (request != null) {
            return new CalendarQueryRequestInfoImpl(request);
        }
        return null;
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo) {
        return new CalendarImpl(resource, clientUtils, queryInfo);
    }

    protected DateRangeFilter getDateRangeFromRequest(SlingHttpServletRequest request) throws InvalidDateException {
        if (request != null) {
            DateRangeFilterImpl filter = null;
            String[] selectors = request.getRequestPathInfo().getSelectors();
            if (selectors != null && selectors.length >= 3) {
                String dateRange = selectors[2];
                String[] s = dateRange.split("_");
                filter = s != null && s.length == 2 ? new DateRangeFilterImpl(s[0], s[1], true, true) : new DateRangeFilterImpl(dateRange, null, true, true);
            } else {
                try {
                    Calendar today = dateUtil.getMonthStart();
                    filter = new DateRangeFilterImpl(DateUtil.getISO8601DateNoTime(today), "1M", true, true);
                }
                catch (InvalidDateException e) {
                    // empty catch block
                }
            }
            return filter;
        }
        throw new NullPointerException("request argument is null.");
    }
}

