/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.blog.antispam.process;

import com.adobe.cq.social.blog.Blog;
import com.adobe.cq.social.blog.BlogManager;
import com.adobe.cq.social.blog.antispam.AkismetService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Check Spam"})
public class CheckSpamProcess
implements WorkflowProcess {
    private static final String COMMENT_RESOURCE_TYPE = "social/commons/components/comments/comment";
    private static final String TRACKBACK_RESOURCE_TYPE = "social/blog/components/trackbacks";
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    private static final String TYPE_JCR_PATH = "JCR_PATH";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private AkismetService akismetService;
    @Reference
    private JcrResourceResolverFactory jcrResourceResolverFactory;

    protected void activate(ComponentContext context) {
        this.logger.info("verifying key for spam check");
        boolean isValidKey = this.akismetService.isVerifiedKey();
        if (isValidKey) {
            this.logger.info("Key for Akismet is valid");
        }
    }

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block23: {
            Session session = workflowSession.getSession();
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            try {
                String payloadData;
                if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null && session.itemExists(payloadData = (String)data.getPayload())) {
                    path = payloadData;
                }
                if (path != null) {
                    Node userGeneratedNode = (Node)session.getItem(path);
                    if (userGeneratedNode.hasProperty(SLING_RESOURCE_TYPE) && userGeneratedNode.getProperty(SLING_RESOURCE_TYPE).getString().equals(COMMENT_RESOURCE_TYPE)) {
                        this.logger.debug("Spam check for comment node at " + userGeneratedNode.getPath());
                        String ipAddress = null;
                        if (!userGeneratedNode.hasProperty("ip")) {
                            this.setIsSpam(userGeneratedNode, false, session);
                            this.logger.info("Comment has no IP address, setting isSpam to false");
                            return;
                        }
                        ipAddress = userGeneratedNode.getProperty("ip").getString();
                        this.logger.debug("Spam check for comment node with ip " + ipAddress);
                        if (ipAddress.equalsIgnoreCase("127.0.0.1") || ipAddress.equalsIgnoreCase("localhost") || ipAddress.equalsIgnoreCase("0:0:0:0:0:0:0:1")) {
                            this.setIsSpam(userGeneratedNode, false, session);
                            this.logger.info("Comment IP address is localhost, setting isSpam to false");
                            return;
                        }
                        String userAgent = null;
                        if (!userGeneratedNode.hasProperty("userAgent")) {
                            this.setIsSpam(userGeneratedNode, false, session);
                            this.logger.info("Comment has no user agent, setting isSpam to false");
                            return;
                        }
                        userAgent = userGeneratedNode.getProperty("userAgent").getString();
                        this.logger.debug("Spam check for comment node with userAgent " + userAgent);
                        String referrer = null;
                        if (userGeneratedNode.hasProperty("referer")) {
                            referrer = userGeneratedNode.getProperty("referer").getString();
                            this.logger.debug("Spam check for comment node with referrer " + referrer);
                        }
                        String permalink = null;
                        try {
                            ResourceResolver resourceResolver = this.jcrResourceResolverFactory.getResourceResolver(session);
                            Resource resource = resourceResolver.getResource(path);
                            BlogManager blogManager = resource.getResourceResolver().adaptTo(BlogManager.class);
                            Blog entry = blogManager.getBlog(path);
                            permalink = entry.getFullUrl();
                            this.logger.debug("Spam check for comment node with permalink " + permalink);
                        }
                        catch (Exception e) {
                            this.logger.error("Exception " + e.toString() + " getting permalink");
                        }
                        String author = null;
                        if (userGeneratedNode.hasProperty("userIdentifier")) {
                            author = userGeneratedNode.getProperty("userIdentifier").getString();
                            this.logger.debug("Spam check for comment node with permalink " + author);
                        }
                        String authorEmail = null;
                        if (userGeneratedNode.hasProperty("email")) {
                            authorEmail = userGeneratedNode.getProperty("email").getString();
                            this.logger.debug("Spam check for comment node with author " + authorEmail);
                        }
                        String authorURL = null;
                        if (userGeneratedNode.hasProperty("url")) {
                            authorURL = userGeneratedNode.getProperty("url").getString();
                            this.logger.debug("Spam check for comment node with authorURL " + authorURL);
                        }
                        String commentText = null;
                        if (userGeneratedNode.hasProperty("jcr:description")) {
                            commentText = userGeneratedNode.getProperty("jcr:description").getString();
                            this.logger.debug("Spam check for comment node with commentText " + commentText);
                        }
                        boolean isSpam = this.akismetService.commentCheck(ipAddress, userAgent, referrer, permalink, "comment", author, authorEmail, authorURL, commentText, null);
                        this.setIsSpam(userGeneratedNode, isSpam, session);
                        this.logger.info("Spam check result " + isSpam + " for comment: " + workItem.toString());
                        break block23;
                    }
                    if (userGeneratedNode.hasProperty(SLING_RESOURCE_TYPE) && userGeneratedNode.getProperty(SLING_RESOURCE_TYPE).getString().equals(TRACKBACK_RESOURCE_TYPE)) {
                        String ipAddress = null;
                        if (userGeneratedNode.hasProperty("ip")) {
                            ipAddress = userGeneratedNode.getProperty("ip").getString();
                            this.logger.debug("Spam check for trackback node with ip " + ipAddress);
                        }
                        String authorURL = null;
                        if (userGeneratedNode.hasProperty("url")) {
                            authorURL = userGeneratedNode.getProperty("url").getString();
                            this.logger.debug("Spam check for trackback node with authorURL " + authorURL);
                        }
                        String permalink = null;
                        try {
                            ResourceResolver resourceResolver = this.jcrResourceResolverFactory.getResourceResolver(session);
                            Resource resource = resourceResolver.getResource(path);
                            BlogManager blogManager = resource.getResourceResolver().adaptTo(BlogManager.class);
                            Blog entry = blogManager.getBlog(path);
                            permalink = entry.getFullUrl();
                            this.logger.debug("Spam check for trackback node with permalink " + permalink);
                        }
                        catch (Exception e) {
                            this.logger.error("Exception " + e.toString() + " getting permalink");
                        }
                        String author = null;
                        if (userGeneratedNode.hasProperty("blogName")) {
                            author = userGeneratedNode.getProperty("blogName").getString();
                            this.logger.debug("Spam check for trackback node with blogName " + author);
                        }
                        String excerpt = "";
                        if (userGeneratedNode.hasProperty("excerpt")) {
                            excerpt = userGeneratedNode.getProperty("excerpt").getString();
                            this.logger.debug("Spam check for trackback node with excerpt " + excerpt);
                        }
                        if (userGeneratedNode.hasProperty("jcr:title")) {
                            excerpt = userGeneratedNode.getProperty("jcr:title").getString() + " " + excerpt;
                            this.logger.debug("Spam check for trackback node with title " + userGeneratedNode.hasProperty("jcr:title"));
                        }
                        boolean isSpam = this.akismetService.commentCheck(ipAddress, null, null, permalink, "trackback", author, null, authorURL, excerpt, null);
                        this.setIsSpam(userGeneratedNode, isSpam, session);
                        this.logger.info("Spam check result " + isSpam + " for trackback: " + workItem.toString());
                        break block23;
                    }
                    this.logger.warn("Cannot check for spam because item is not a comment or a trackback. Workitem: " + workItem.toString());
                    break block23;
                }
                this.logger.warn("Cannot check for spam because path is null for this workitem: " + workItem.toString());
            }
            catch (RepositoryException e) {
                throw new WorkflowException(e);
            }
        }
    }

    private void setIsSpam(Node commentNode, boolean value, Session session) throws WorkflowException {
        try {
            commentNode.setProperty("isSpam", value);
            session.save();
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }

    protected void bindAkismetService(AkismetService akismetService) {
        this.akismetService = akismetService;
    }

    protected void unbindAkismetService(AkismetService akismetService) {
        if (this.akismetService == akismetService) {
            this.akismetService = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

