/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.blog;

import com.adobe.cq.social.blog.BlogEntry;
import com.adobe.cq.social.blog.BlogEntryFilter;

public class ParentPathEntryFilter
implements BlogEntryFilter {
    private final String parentPath;

    public ParentPathEntryFilter(String path) {
        this.parentPath = path;
    }

    @Override
    public boolean pass(BlogEntry entry) {
        if (this.parentPath == null) {
            return true;
        }
        try {
            String entryParentPath = entry.getPage().getParent().getPath();
            if (this.parentPath.indexOf("/") != -1) {
                return entryParentPath.endsWith(this.parentPath);
            }
            return entryParentPath.indexOf(this.parentPath) != -1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

