/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.qom;

import com.adobe.cq.searchcollections.qom.OperandEvaluator;
import com.adobe.cq.searchcollections.qom.ValueComparator;
import java.util.Comparator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowComparator
implements Comparator<Row> {
    private final ValueComparator comparator = new ValueComparator();
    private final Ordering[] orderings;
    private final OperandEvaluator evaluator;

    public RowComparator(Ordering[] orderings, OperandEvaluator evaluator) {
        this.orderings = orderings;
        this.evaluator = evaluator;
    }

    @Override
    public int compare(Row a, Row b) {
        try {
            for (Ordering ordering : this.orderings) {
                Value[] vb;
                DynamicOperand operand = ordering.getOperand();
                Value[] va = this.evaluator.getValues((Operand)operand, a);
                int d = this.compare(va, vb = this.evaluator.getValues((Operand)operand, b));
                if (d == 0) continue;
                if ("jcr.order.descending".equals(ordering.getOrder())) {
                    return -d;
                }
                return d;
            }
            return 0;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare rows " + a + " and " + b, e);
        }
    }

    @Override
    private int compare(Value[] a, Value[] b) {
        for (int i = 0; i < a.length && i < b.length; ++i) {
            int d = this.comparator.compare(a[i], b[i]);
            if (d == 0) continue;
            return d;
        }
        return a.length - b.length;
    }
}

