/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import com.adobe.cq.searchcollections.api.SearchCollection;
import com.adobe.cq.searchcollections.lucene.DefaultNodeIndexer;
import com.adobe.cq.searchcollections.lucene.IndexerUtil;
import com.adobe.cq.searchcollections.lucene.JCRDirectory;
import com.adobe.cq.searchcollections.lucene.JCRLockFactory;
import com.adobe.cq.searchcollections.lucene.LuceneSearchCollectionConfig;
import com.adobe.cq.searchcollections.lucene.NodeIndexer;
import com.adobe.cq.searchcollections.lucene.QueryObjectModelFactoryImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.query.sql2.SQL2QOMBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.params.CountFacetRequest;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.similar.MoreLikeThis;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchCollection
implements SearchCollection {
    private static final Logger log = LoggerFactory.getLogger(LuceneSearchCollection.class);
    private final Session session;
    private final String path;
    private final NodeIndexer indexer;
    private final JCRDirectory directory;
    private JCRDirectory taxoDirectory;
    private final Analyzer analyzer = new StandardAnalyzer(Version.LUCENE_36);
    private final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    private final LuceneSearchCollectionConfig indexConfig;
    private volatile boolean running = true;
    private final Collection<String> queue = new LinkedHashSet<String>();
    private Thread wThread = null;
    private Object execSync = new Object();
    private Date exec = null;
    private static Object writeSync = new Object();

    public LuceneSearchCollection(Node directory, Node taxoDirectory, NodeIndexer indexer, boolean useJCRLocks) throws RepositoryException {
        this.session = directory.getSession();
        this.path = directory.getPath();
        this.indexer = indexer;
        this.directory = new JCRDirectory(directory);
        this.taxoDirectory = null;
        if (null != taxoDirectory) {
            this.taxoDirectory = new JCRDirectory(taxoDirectory);
        }
        try {
            if (useJCRLocks) {
                this.directory.setLockFactory(new JCRLockFactory(this.session, directory.getPath()));
                if (null != taxoDirectory) {
                    this.taxoDirectory.setLockFactory(new JCRLockFactory(this.session, directory.getPath()));
                }
            } else {
                this.directory.setLockFactory((LockFactory)new SingleInstanceLockFactory());
                if (null != taxoDirectory) {
                    this.taxoDirectory.setLockFactory((LockFactory)new SingleInstanceLockFactory());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.indexConfig = new LuceneSearchCollectionConfig(directory);
        this.wThread = new Thread(new WorkerThread());
        this.wThread.start();
    }

    public LuceneSearchCollection(Node directory) throws RepositoryException {
        this(directory, null, new DefaultNodeIndexer(), false);
    }

    public LuceneSearchCollection(Node directory, NodeIndexer indexer) throws RepositoryException {
        this(directory, null, indexer, false);
    }

    public LuceneSearchCollection(Node directory, Node taxoDirectory, NodeIndexer indexer) throws RepositoryException {
        this(directory, taxoDirectory, indexer, false);
    }

    public Map<String, Integer> findFacets(String fieldName, String resourceTypeFilter, String componentFilter, int count) throws RepositoryException {
        try {
            HashMap<String, Integer> result = null;
            if (null != this.taxoDirectory) {
                IndexReader index = IndexReader.open((Directory)this.directory);
                IndexSearcher searcher = new IndexSearcher(index);
                DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader((Directory)this.taxoDirectory);
                BooleanQuery booleanQuery = new BooleanQuery();
                if (resourceTypeFilter != null || componentFilter != null) {
                    if (resourceTypeFilter != null) {
                        Query resourceTypeQuery = new QueryParser(Version.LUCENE_36, "resourceType", this.analyzer).parse(resourceTypeFilter);
                        booleanQuery.add(resourceTypeQuery, BooleanClause.Occur.MUST);
                    }
                    if (componentFilter != null) {
                        String escapedComponentFilter = QueryParser.escape((String)componentFilter);
                        Query componentQuery = new QueryParser(Version.LUCENE_36, "component", this.keywordAnalyzer).parse(escapedComponentFilter);
                        booleanQuery.add(componentQuery, BooleanClause.Occur.MUST);
                    }
                }
                DefaultFacetIndexingParams indexingParams = new DefaultFacetIndexingParams();
                FacetSearchParams facetSearchParams = new FacetSearchParams((FacetIndexingParams)indexingParams);
                facetSearchParams.addFacetRequest((FacetRequest)new CountFacetRequest(new CategoryPath(new CharSequence[]{fieldName}), count));
                TopScoreDocCollector topDocsCollector = TopScoreDocCollector.create((int)10, (boolean)true);
                FacetsCollector facetsCollector = new FacetsCollector(facetSearchParams, index, (TaxonomyReader)taxo);
                searcher.search((Query)booleanQuery, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, facetsCollector}));
                List res = facetsCollector.getFacetResults();
                result = new HashMap<String, Integer>();
                for (FacetResult fRes : res) {
                    for (FacetResultNode n : fRes.getFacetResultNode().getSubResults()) {
                        result.put(n.getLabel().lastComponent(), (int)n.getValue());
                    }
                }
            }
            return result;
        }
        catch (FileNotFoundException e) {
            log.warn("Empty search collection.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParseException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<String> findMLT(String target, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        try {
            IndexReader index = IndexReader.open((Directory)this.directory);
            IndexSearcher searcher = new IndexSearcher((Directory)this.directory, true);
            MoreLikeThis mlt = new MoreLikeThis(index);
            mlt.setFieldNames(mltFields);
            mlt.setMinTermFreq(minTermFreq);
            mlt.setMinDocFreq(minDocFreq);
            Query query = mlt.like((Reader)new StringReader(target));
            QueryWrapperFilter additionalFilters = null;
            if (resourceTypeFilter != null || componentFilter != null) {
                BooleanQuery booleanQuery = new BooleanQuery();
                if (resourceTypeFilter != null) {
                    Query resourceTypeQuery = new QueryParser(Version.LUCENE_36, "resourceType", this.analyzer).parse(resourceTypeFilter);
                    booleanQuery.add(resourceTypeQuery, BooleanClause.Occur.MUST);
                }
                if (componentFilter != null) {
                    String escapedComponentFilter = IndexerUtil.escapeQuery(componentFilter);
                    Query componentQuery = new QueryParser(Version.LUCENE_36, "component", this.analyzer).parse(escapedComponentFilter);
                    booleanQuery.add(componentQuery, BooleanClause.Occur.MUST);
                }
                additionalFilters = new QueryWrapperFilter((Query)booleanQuery);
            }
            TopDocs topDocs = additionalFilters == null ? searcher.search(query, maxResults) : searcher.search(query, additionalFilters, maxResults);
            String pathField = ":path".intern();
            LinkedList<String> results = new LinkedList<String>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = searcher.doc(scoreDoc.doc);
                String path = doc.get(pathField);
                results.add(path);
            }
            return results;
        }
        catch (FileNotFoundException e) {
            log.warn("Empty search collection.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParseException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public javax.jcr.query.Query createQuery(Session session, String statement, String language) throws RepositoryException {
        if (!"JCR-SQL2".equals(language) && !"JCR-JQOM".equals(language)) {
            throw new RepositoryException("Query language not supported: " + language);
        }
        QueryObjectModelFactoryImpl factory = new QueryObjectModelFactoryImpl(this.directory, this.analyzer, session);
        SQL2QOMBuilder b = new SQL2QOMBuilder();
        return b.createQueryObjectModel(statement, factory, session.getValueFactory());
    }

    @Override
    public synchronized void update(Set<String> paths) {
        int skip = 0;
        for (String p : paths) {
            if (p.startsWith(this.path) || !this.indexConfig.shouldInclude(p)) {
                ++skip;
                continue;
            }
            this.queue.add(p);
        }
        int index = this.queue.size();
        log.debug("Lucene SearchCollection pinged, will index {}, will skip {}.", (Object)index, (Object)skip);
        if (index > 0) {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (!this.running) {
            return;
        }
        Object object = this.execSync;
        synchronized (object) {
            this.exec = new Date();
            this.execSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        this.running = false;
        for (int i = 0; i < 10; ++i) {
            Object object = this.execSync;
            synchronized (object) {
                this.exec = new Date();
                this.execSync.notify();
            }
            if (!this.wThread.isAlive()) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable t) {
                log.error("Error waiting for working thread to shut down.", t);
            }
        }
        this.session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Collection<String> paths) {
        if (paths.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        try {
            IndexWriter writer = new IndexWriter((Directory)this.directory, this.analyzer, IndexWriter.MaxFieldLength.LIMITED);
            writer.setRAMBufferSizeMB(48.0);
            DirectoryTaxonomyWriter taxo = null;
            CategoryDocumentBuilder categoryDocBuilder = null;
            if (null != this.taxoDirectory) {
                taxo = new DirectoryTaxonomyWriter((Directory)this.taxoDirectory, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                categoryDocBuilder = new CategoryDocumentBuilder((TaxonomyWriter)taxo);
            }
            try {
                for (String path : paths) {
                    writer.deleteDocuments(this.indexer.getSubtreeQuery(path));
                    Node node = null;
                    try {
                        node = this.session.getNode(path);
                    }
                    catch (PathNotFoundException e) {
                    }
                    catch (RepositoryException e) {
                        log.warn("Lucene SearchCollection problem, ignoring update: " + path, (Throwable)e);
                    }
                    try {
                        if (node == null) continue;
                        Document doc = this.indexer.createDocument(node, categoryDocBuilder);
                        if (null != taxo) {
                            taxo.commit();
                        }
                        if (doc == null) continue;
                        writer.addDocument(doc);
                    }
                    catch (RepositoryException e) {
                        log.warn("Lucene SearchCollection problem, ignoring update: " + path, (Throwable)e);
                    }
                }
            }
            finally {
                writer.close();
                if (null != taxo) {
                    taxo.close();
                }
                log.debug("Lucene SearchCollection done indexing, took {} ms.", (Object)(System.currentTimeMillis() - time));
            }
        }
        catch (IOException e) {
            log.warn("Lucene SearchCollection problem, ignoring updates: " + paths, (Throwable)e);
        }
    }

    private synchronized Collection<String> getPendingPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.queue);
        this.queue.clear();
        return paths;
    }

    class WorkerThread
    implements Runnable {
        private Date lastExec = null;

        WorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (LuceneSearchCollection.this.running) {
                Object object;
                if (LuceneSearchCollection.this.exec == null || LuceneSearchCollection.this.exec.equals(this.lastExec)) {
                    object = LuceneSearchCollection.this.execSync;
                    synchronized (object) {
                        if (LuceneSearchCollection.this.exec == null || LuceneSearchCollection.this.exec.equals(this.lastExec)) {
                            try {
                                LuceneSearchCollection.this.execSync.wait();
                            }
                            catch (InterruptedException e) {
                                log.error("Error executing execSync.wait().", (Throwable)e);
                                continue;
                            }
                        }
                    }
                }
                if (!LuceneSearchCollection.this.running) {
                    return;
                }
                try {
                    object = LuceneSearchCollection.this.execSync;
                    synchronized (object) {
                        this.lastExec = LuceneSearchCollection.this.exec;
                    }
                    object = writeSync;
                    synchronized (object) {
                        LuceneSearchCollection.this.doUpdate(LuceneSearchCollection.this.getPendingPaths());
                    }
                }
                catch (Throwable t) {
                    log.error("Error executing doUpdate.", t);
                }
            }
        }
    }
}

