/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JCRIndexInput
extends IndexInput {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final byte[] data;
    private int position = 0;

    public JCRIndexInput(byte[] data, String name) throws IOException {
        super(name);
        this.data = data;
    }

    public byte readByte() throws IOException {
        if (this.position < this.data.length) {
            return this.data[this.position++];
        }
        throw new IOException();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.data.length == 0 && offset == 0 && len == 0) {
            return;
        }
        if (this.position + len <= this.data.length) {
            System.arraycopy(this.data, this.position, b, offset, len);
            this.position += len;
        } else {
            throw new IOException("real len " + this.data.length + ", req: " + this.position + "/" + len);
        }
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        this.log.debug("seek {} {}", (Object)pos, (Object)this.data.length);
        if (0L > pos || pos > (long)this.data.length) {
            throw new IOException();
        }
        this.position = (int)pos;
    }

    public long length() {
        return this.data.length;
    }

    public void close() throws IOException {
    }
}

