/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import com.adobe.cq.searchcollections.lucene.JCRIndexInput;
import com.adobe.cq.searchcollections.lucene.JCRIndexOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class JCRDirectory
extends Directory {
    private final Node directory;

    public JCRDirectory(Node directory) {
        this.directory = directory;
    }

    public synchronized String[] listAll() throws IOException {
        try {
            ArrayList<String> names = new ArrayList<String>();
            for (Node file : JcrUtils.getChildNodes(this.directory)) {
                names.add(file.getName());
            }
            return names.toArray(new String[names.size()]);
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized boolean fileExists(String name) throws IOException {
        try {
            return this.directory.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized long fileModified(String name) throws IOException {
        try {
            Node file = this.directory.getNode(name);
            Node content = file.getNode("{http://www.jcp.org/jcr/1.0}content");
            return content.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getLong();
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized void touchFile(String name) throws IOException {
        try {
            Node file = this.directory.getNode(name);
            Node content = file.getNode("{http://www.jcp.org/jcr/1.0}content");
            content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", System.currentTimeMillis());
            this.directory.getSession().save();
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized void deleteFile(String name) throws IOException {
        try {
            this.directory.getNode(name).remove();
            this.directory.getSession().save();
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized long fileLength(String name) throws IOException {
        try {
            Node file = this.directory.getNode(name);
            Node content = file.getNode("{http://www.jcp.org/jcr/1.0}content");
            return content.getProperty("{http://www.jcp.org/jcr/1.0}data").getLength();
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    public synchronized IndexInput openInput(String name) throws IOException {
        byte[] data = this.readFile(name);
        if (data != null) {
            return new JCRIndexInput(data, name);
        }
        throw new IOException();
    }

    public synchronized IndexOutput createOutput(String name) throws IOException {
        this.writeFile(name, new byte[0]);
        return new JCRIndexOutput(this, name);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    synchronized byte[] readFile(String name) throws IOException {
        try {
            Node file = this.directory.getNode(name);
            Node content = file.getNode("{http://www.jcp.org/jcr/1.0}content");
            Binary binary = content.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
            try {
                byte[] byArray;
                InputStream stream = binary.getStream();
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)buffer);
                    byArray = buffer.toByteArray();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return byArray;
            }
            finally {
                binary.dispose();
            }
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }

    synchronized void writeFile(String name, byte[] data) throws IOException {
        try {
            JcrUtils.putFile(this.directory, name, "application/octet-stream", new ByteArrayInputStream(data));
            this.directory.getSession().save();
        }
        catch (RepositoryException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
    }
}

