/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.launches.api;

import java.util.Calendar;
import java.util.Date;

public final class LaunchResourceStatus {
    private final String resourcePath;
    private final String title;
    private final Calendar launchModificationDate;
    private final Calendar productionModificationDate;
    private final String launchUserId;
    private final String productionUserId;
    private final LaunchStatusType type;

    public LaunchResourceStatus(LaunchStatusType type, String path, String title, Calendar launchLastModif, Calendar prodLastModif, String launchUserId, String productionUserId) {
        this.type = type;
        this.resourcePath = path;
        this.title = title;
        this.launchModificationDate = launchLastModif;
        this.productionModificationDate = prodLastModif;
        this.launchUserId = launchUserId;
        this.productionUserId = productionUserId;
    }

    public LaunchStatusType getType() {
        return this.type;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getLaunchModificationDate() {
        return this.launchModificationDate != null ? this.launchModificationDate.getTime() : null;
    }

    public Date getProductionModificationDate() {
        return this.productionModificationDate != null ? this.productionModificationDate.getTime() : null;
    }

    public String getLaunchUserId() {
        return this.launchUserId;
    }

    public String getProductionUserId() {
        return this.productionUserId;
    }

    public final boolean equals(Object o) {
        if (o instanceof LaunchResourceStatus) {
            LaunchResourceStatus other = (LaunchResourceStatus)o;
            return other.resourcePath.equals(this.resourcePath) && other.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        return this.resourcePath.hashCode() ^ this.type.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LaunchStatusType {
        CREATED,
        MODIFIED,
        DELETED;


        public String getValue() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.getValue();
        }
    }
}

