/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;
import com.day.cq.commons.ImageResource;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJcrProduct
extends SlingAdaptable
implements Product {
    protected static final String PN_PRODUCT_TYPE = "cq:commerceType";
    protected static final String PN_PRODUCT_VARIANT_AXES = "cq:productVariantAxes";
    protected static final String PN_PRODUCT_DATA = "productData";
    protected static final String PN_PRODUCT_TITLE = "jcr:title";
    protected static final String PN_PRODUCT_DESCRIPTION = "jcr:description";
    protected static final String PN_PRODUCT_IMAGE_CATEGORY = "assetCategory";
    protected static final Logger log = LoggerFactory.getLogger(AbstractJcrProduct.class);
    protected Resource resource;
    protected Product baseProduct;

    public AbstractJcrProduct(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getPagePath() {
        PageManager pm = this.resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(this.resource);
        return page != null ? page.getPath() + ".html#" + this.getSKU() : null;
    }

    @Override
    public String getTitle() {
        return this.getProperty(PN_PRODUCT_TITLE, String.class);
    }

    @Override
    public String getDescription() {
        return this.getProperty(PN_PRODUCT_DESCRIPTION, String.class);
    }

    @Override
    @Deprecated
    public String getImagePath() {
        ImageResource image = this.getImage();
        if (image != null) {
            return image.getPath();
        }
        return "";
    }

    @Override
    @Deprecated
    public String getImageUrl() {
        return this.getImagePath();
    }

    @Override
    @Deprecated
    public String getThumbnailUrl() {
        return this.getThumbnailUrl(-1);
    }

    @Override
    @Deprecated
    public String getThumbnailUrl(int width) {
        ImageResource thumbnail = this.getThumbnail();
        if (thumbnail != null) {
            if (width >= 0) {
                thumbnail.setSelector(thumbnail.getSelector() + "." + width);
            }
            return thumbnail.getHref();
        }
        return "";
    }

    @Override
    public ImageResource getImage() {
        List<ImageResource> images = this.getImages();
        if (images.size() == 1) {
            return images.get(0);
        }
        if (images.size() > 1) {
            PageManager pm;
            Page page;
            String imageCategoryToDisplay = (String)((Object)ResourceUtil.getValueMap(this.resource).get(PN_PRODUCT_IMAGE_CATEGORY, String.class));
            if (StringUtils.isEmpty((String)imageCategoryToDisplay) && AbstractJcrProduct.isAVariant(this.resource)) {
                try {
                    this.baseProduct = this.getBaseProduct();
                    if (this.baseProduct != null) {
                        imageCategoryToDisplay = this.baseProduct.getProperty(PN_PRODUCT_IMAGE_CATEGORY, String.class);
                    }
                }
                catch (CommerceException e) {
                    log.error("Error while retrieving the base product.", (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((String)imageCategoryToDisplay) && (page = (pm = this.resource.getResourceResolver().adaptTo(PageManager.class)).getContainingPage(this.resource)) != null) {
                Resource pageContent = page.getContentResource();
                HierarchyNodeInheritanceValueMap dataMap = new HierarchyNodeInheritanceValueMap(pageContent);
                imageCategoryToDisplay = (String)((Object)dataMap.getInherited(PN_PRODUCT_IMAGE_CATEGORY, String.class));
            }
            if (StringUtils.isEmpty((String)imageCategoryToDisplay)) {
                imageCategoryToDisplay = this.getProperty(PN_PRODUCT_IMAGE_CATEGORY, String.class);
            }
            for (ImageResource image : images) {
                String category = image.get(PN_PRODUCT_IMAGE_CATEGORY);
                if (!category.equals(imageCategoryToDisplay)) continue;
                return image;
            }
            return images.get(0);
        }
        return null;
    }

    @Override
    public List<ImageResource> getImages() {
        Resource ancestor;
        List<ImageResource> images = this.getImages(this.resource);
        if (images.size() > 0) {
            return images;
        }
        String productDataPath = (String)((Object)ResourceUtil.getValueMap(this.resource).get(PN_PRODUCT_DATA, String.class));
        if (StringUtils.isNotEmpty((String)productDataPath)) {
            ancestor = this.resource.getResourceResolver().getResource(productDataPath);
            if (ancestor == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return Collections.emptyList();
            }
        } else {
            ancestor = this.resource.getParent();
        }
        while (ancestor != null && AbstractJcrProduct.isAProductOrVariant(ancestor)) {
            images = this.getImages(ancestor);
            if (images.size() > 0) {
                return images;
            }
            ancestor = ancestor.getParent();
        }
        return Collections.emptyList();
    }

    @Override
    public ImageResource getThumbnail() {
        ImageResource thumbnail = this.getImage();
        if (thumbnail != null) {
            thumbnail.setSelector(".thumbnail");
        }
        return thumbnail;
    }

    protected List<ImageResource> getImages(Resource resource) {
        Resource imagesResource;
        ArrayList<ImageResource> result = new ArrayList<ImageResource>();
        Resource legacyImageResource = resource.getChild("image");
        if (legacyImageResource != null) {
            result.add(new ImageResource(legacyImageResource));
        }
        if ((imagesResource = resource.getChild("assets")) != null) {
            Iterator<Resource> images = imagesResource.listChildren();
            while (images.hasNext()) {
                result.add(new ImageResource(images.next()));
            }
        }
        return result;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Resource productData;
        Object value = null;
        ValueMap map = ResourceUtil.getValueMap(this.resource);
        if (map.containsKey(name)) {
            return (T)map.get(name, type);
        }
        if (map.containsKey(PN_PRODUCT_DATA)) {
            String productDataPath = (String)((Object)map.get(PN_PRODUCT_DATA, String.class));
            productData = this.resource.getResourceResolver().getResource(productDataPath);
            if (productData == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return null;
            }
        } else {
            productData = this.resource;
        }
        ComponentInheritanceValueMap dataMap = new ComponentInheritanceValueMap(productData);
        return (T)dataMap.getInherited(name, type);
    }

    @Override
    public Iterator<Product> getVariants() throws CommerceException {
        return this.getVariants(null);
    }

    @Override
    public boolean axisIsVariant(String axis) {
        Iterator<String> axes = this.getVariantAxes();
        while (axes.hasNext()) {
            if (!axes.next().equals(axis)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Product> getVariants(VariantFilter filter) throws CommerceException {
        ArrayList<Product> variants = new ArrayList<Product>();
        this.collectVariants(this.getBaseProduct(), filter, variants);
        return variants.iterator();
    }

    @Override
    public Iterator<String> getVariantAxes() {
        String[] axes = this.getProperty(PN_PRODUCT_VARIANT_AXES, String[].class);
        if (axes != null) {
            return Arrays.asList(axes).iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public Product getBaseProduct() throws CommerceException {
        if (this.baseProduct == null) {
            if (!AbstractJcrProduct.isAProductOrVariant(this.resource)) {
                log.error("Node isn't a product: " + this.resource.getPath());
                return null;
            }
            Resource tempResource = this.resource;
            while (AbstractJcrProduct.isAVariant(tempResource)) {
                tempResource = tempResource.getParent();
            }
            if (AbstractJcrProduct.isABaseProduct(tempResource)) {
                CommerceService service = tempResource.adaptTo(CommerceService.class);
                this.baseProduct = service.getProduct(tempResource.getPath());
            } else {
                log.error("Variant product node [{}] didn't have a product parent.", (Object)this.resource.getPath());
                return null;
            }
        }
        return this.baseProduct;
    }

    @Override
    public Product getPIMProduct() throws CommerceException {
        String productDataPath = (String)((Object)ResourceUtil.getValueMap(this.resource).get(PN_PRODUCT_DATA, String.class));
        if (StringUtils.isNotEmpty((String)productDataPath)) {
            Resource productData = this.resource.getResourceResolver().getResource(productDataPath);
            if (productData == null) {
                log.warn("Product data not found at [{}].", (Object)productDataPath);
                return null;
            }
            return productData.adaptTo(Product.class);
        }
        return null;
    }

    public static boolean isAVariant(Resource resource) {
        return ResourceUtil.getValueMap(resource).get(PN_PRODUCT_TYPE, "").equals("variant");
    }

    public static boolean isABaseProduct(Resource resource) {
        return ResourceUtil.getValueMap(resource).get(PN_PRODUCT_TYPE, "").equals("product");
    }

    public static boolean isAProductOrVariant(Resource resource) {
        String commerceType = ResourceUtil.getValueMap(resource).get(PN_PRODUCT_TYPE, "");
        return commerceType.equals("product") || commerceType.equals("variant");
    }

    protected void collectVariants(Product p, VariantFilter filter, List<Product> variants) {
        boolean isLeaf = true;
        Iterator<Resource> i = this.resource.getResourceResolver().listChildren(p.adaptTo(Resource.class));
        while (i != null && i.hasNext()) {
            Resource child = i.next();
            if (!AbstractJcrProduct.isAVariant(child)) continue;
            isLeaf = false;
            this.collectVariants(child.adaptTo(Product.class), filter, variants);
        }
        if (isLeaf && (filter == null || filter.includes(p))) {
            variants.add(p);
        }
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == InheritanceValueMap.class) {
            return (AdapterType)new ComponentInheritanceValueMap(this.resource);
        }
        AdapterType ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.resource.adaptTo(type);
        }
        return ret;
    }
}

