/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.AbstractJcrCommerceServiceFactory;
import com.adobe.cq.commerce.common.CommerceSearchProvider;
import com.adobe.cq.commerce.common.ServiceContext;
import com.adobe.cq.commerce.common.VendorJcrPlacedOrder;
import com.day.cq.wcm.api.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public abstract class AbstractJcrCommerceService
implements CommerceService {
    private final ServiceContext serviceContext;
    protected Map<String, Object> context = new HashMap<String, Object>();
    protected CommerceSearchProvider searchProvider;
    protected ResourceResolver resolver;
    @Deprecated
    public AbstractJcrCommerceServiceFactory.Services services;

    protected AbstractJcrCommerceService(ServiceContext serviceContext, Resource resource) {
        this.serviceContext = serviceContext;
        this.resolver = resource.getResourceResolver();
    }

    public ServiceContext serviceContext() {
        return this.serviceContext;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public String getServer() {
        return null;
    }

    @Override
    public boolean isActivated(Product product) throws CommerceException {
        return true;
    }

    @Override
    public Promotion getPromotion(String path) throws CommerceException {
        Resource resource = this.resolver.getResource(path);
        return resource != null ? resource.adaptTo(Promotion.class) : null;
    }

    @Override
    public Voucher getVoucher(String path) throws CommerceException {
        Resource resource = this.resolver.getResource(path);
        return resource != null ? resource.adaptTo(Voucher.class) : null;
    }

    public VendorJcrPlacedOrder getPlacedOrder(String orderId, Locale locale) {
        return new VendorJcrPlacedOrder(this, orderId, locale);
    }

    @Override
    public void catalogRolloutHook(Page blueprint, Page catalog) throws CommerceException {
    }

    @Override
    public void sectionRolloutHook(Page blueprint, Page section) {
    }

    @Override
    public void productRolloutHook(Product productData, Page productPage, Product productReference) throws CommerceException {
    }

    @Override
    public CommerceResult search(CommerceQuery query) throws CommerceException {
        if (this.searchProvider == null) {
            this.searchProvider = this.getSearchProvider();
        }
        if (this.searchProvider != null) {
            return this.searchProvider.search(query, this);
        }
        return null;
    }

    protected CommerceSearchProvider getSearchProvider() throws CommerceException {
        String providerName = this.getSearchProviderName();
        if (providerName != null) {
            return this.serviceContext.searchProviderManager.getSearchProvider(providerName);
        }
        return null;
    }

    protected String getSearchProviderName() {
        return null;
    }

    @Override
    public List<Promotion> getAvailablePromotions(ResourceResolver resourceResolver) throws CommerceException {
        PromotionManager promotionManager = resourceResolver.adaptTo(PromotionManager.class);
        return promotionManager.getAvailablePromotions(resourceResolver);
    }

    @Deprecated
    public AbstractJcrCommerceService(AbstractJcrCommerceServiceFactory.Services services) {
        this((ServiceContext)null);
        this.services = services;
    }

    @Deprecated
    protected AbstractJcrCommerceService(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

