/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.api;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class PriceInfo
extends ValueMapDecorator {
    public static final String MIN_QUANTITY = "minQuantity";
    private BigDecimal amount;
    private Currency currency;
    private Locale locale;

    @Deprecated
    public PriceInfo(BigDecimal amount, Currency currency) {
        super(new HashMap<String, Object>());
        this.amount = amount;
        this.currency = currency;
        this.locale = null;
    }

    public PriceInfo(BigDecimal amount, Locale locale) {
        super(new HashMap<String, Object>());
        this.amount = amount;
        this.currency = Currency.getInstance(locale);
        this.locale = locale;
    }

    public PriceInfo(BigDecimal amount, Locale locale, Currency currency) {
        super(new HashMap<String, Object>());
        this.amount = amount;
        this.locale = locale;
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public long getQuantity() {
        return this.get(MIN_QUANTITY, 1L);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getFormattedString() {
        NumberFormat nf;
        if (this.amount == null) {
            return "";
        }
        if (this.locale != null) {
            nf = NumberFormat.getCurrencyInstance(this.locale);
            nf.setCurrency(this.currency);
        } else {
            nf = NumberFormat.getCurrencyInstance();
            nf.setCurrency(this.currency);
            nf.setMinimumFractionDigits(2);
            nf.setMaximumFractionDigits(2);
        }
        return nf.format(this.amount);
    }

    @Override
    public String toString() {
        return this.getFormattedString();
    }
}

