/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.address.api;

import com.adobe.cq.address.api.AddressException;
import java.util.Map;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Address
extends SlingAdaptable
implements Comparable<Address> {
    public static final String LABEL = "label";
    public static final String TITLE = "title";
    public static final String FIRST_NAME = "firstname";
    public static final String LAST_NAME = "lastname";
    public static final String STREET_LINE1 = "street1";
    public static final String STREET_LINE2 = "street2";
    public static final String CITY = "city";
    public static final String ZIP_CODE = "zip";
    public static final String STATE = "state";
    public static final String COUNTRY = "country";
    public static final String PARAM_ADDRESS_PATH = "addressPath";
    private static final Logger log = LoggerFactory.getLogger(Address.class);
    private Resource addressRes;
    private ValueMap properties;
    private ResourceResolver resolver;

    public Address(Resource res) {
        if (res == null) {
            throw new IllegalArgumentException("Cannot instantiate address. Resource cannot be null.");
        }
        this.addressRes = res;
        this.properties = res.adaptTo(ValueMap.class);
        this.resolver = res.getResourceResolver();
    }

    public String getPath() {
        return this.addressRes.getPath();
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.properties.get(key, type);
    }

    public <T> T getProperty(String key, T defaultValue) {
        return this.properties.get(key, defaultValue);
    }

    public void setProperties(Map<String, Object> properties) throws AddressException {
        ModifiableValueMap addressProps = this.addressRes.adaptTo(ModifiableValueMap.class);
        addressProps.clear();
        addressProps.putAll(properties);
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new AddressException("Failed to persist the address properties", e);
        }
        this.properties = addressProps;
        log.debug("Properties were set for address {}", (Object)this.addressRes.getPath());
    }

    public void setProperty(String key, Object value) throws AddressException {
        ModifiableValueMap addressProps = this.addressRes.adaptTo(ModifiableValueMap.class);
        addressProps.put(key, value);
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            throw new AddressException("Failed to persist the address property", e);
        }
        this.properties = addressProps;
        log.debug("Property {} was set for address {}", (Object)key, (Object)this.addressRes.getPath());
    }

    public String getLabel() {
        return this.getProperty(LABEL, "");
    }

    public void setLabel(String label) throws AddressException {
        this.setProperty(LABEL, label);
    }

    public String getTitle() {
        return this.getProperty(TITLE, "");
    }

    public void setTitle(String title) throws AddressException {
        this.setProperty(TITLE, title);
    }

    public String getFirstName() {
        return this.getProperty(FIRST_NAME, "");
    }

    public void setFirstName(String firstName) throws AddressException {
        this.setProperty(FIRST_NAME, firstName);
    }

    public String getLastName() {
        return this.getProperty(LAST_NAME, "");
    }

    public void setLastName(String lastName) throws AddressException {
        this.setProperty(LAST_NAME, lastName);
    }

    public String getStreetLine1() {
        return this.getProperty(STREET_LINE1, "");
    }

    public void setStreetLine1(String streetLine1) throws AddressException {
        this.setProperty(STREET_LINE1, streetLine1);
    }

    public String getStreetLine2() {
        return this.getProperty(STREET_LINE2, "");
    }

    public void setStreetLine2(String streetLine1) throws AddressException {
        this.setProperty(STREET_LINE2, streetLine1);
    }

    public String getCity() {
        return this.getProperty(CITY, "");
    }

    public void setCity(String city) throws AddressException {
        this.setProperty(CITY, city);
    }

    public String getZipCode() {
        return this.getProperty(ZIP_CODE, "");
    }

    public void setZipCode(String zipCode) throws AddressException {
        this.setProperty(ZIP_CODE, zipCode);
    }

    public String getState() {
        return this.getProperty(STATE, "");
    }

    public void setState(String state) throws AddressException {
        this.setProperty(STATE, state);
    }

    public String getCountry() {
        return this.getProperty(COUNTRY, "");
    }

    public void setCountry(String country) throws AddressException {
        this.setProperty(COUNTRY, country);
    }

    @Override
    public int compareTo(Address address) {
        if (address == null) {
            return 1;
        }
        if (this.getLastName() != null && address.getLastName() != null && !this.getLastName().equals(address.getLastName())) {
            return this.getLastName().compareTo(address.getLastName());
        }
        return this.getPath().compareTo(address.getPath());
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.addressRes;
        }
        if (type == ValueMap.class) {
            return (AdapterType)this.properties;
        }
        AdapterType ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.addressRes.adaptTo(type);
        }
        return ret;
    }
}

