/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.synth;

import com.adobe.acs.commons.synth.impl.SynthesizedResource;
import com.adobe.acs.commons.synth.impl.SynthesizedSlingHttpServletRequest;
import com.day.cq.commons.feed.StringResponseWrapper;
import com.day.cq.wcm.api.components.IncludeOptions;
import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public final class Synthesizer {
    private static final String SOME_PATH = "/var/acs-commons/synthesized/%s";

    private Synthesizer() {
    }

    public static Resource buildResource(ResourceResolver resourceResolver, String resourceType, Map<String, Object> properties) {
        SynthesizedResource synthesizedResource = new SynthesizedResource(resourceResolver, SOME_PATH, resourceType, properties);
        return synthesizedResource;
    }

    public static String render(String resourceType, Map<String, Object> properties, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource synthesizedResource = Synthesizer.buildResource(request.getResourceResolver(), resourceType, properties);
        return Synthesizer.doRender(synthesizedResource, "html", request, response, new String[0]);
    }

    public static String render(Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        return Synthesizer.doRender(resource, "html", request, response, new String[0]);
    }

    public static String render(Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response, String extension, String[] selectors) throws ServletException, IOException {
        return Synthesizer.doRender(resource, extension, request, response, selectors);
    }

    private static String doRender(Resource resource, String requestExtension, SlingHttpServletRequest request, SlingHttpServletResponse response, String[] selectors) throws ServletException, IOException {
        SynthesizedSlingHttpServletRequest synthesizedRequest = new SynthesizedSlingHttpServletRequest(request).setMethod("GET").setSelectors(selectors).setExtension(requestExtension).setResource(resource);
        RequestDispatcherOptions rdo = new RequestDispatcherOptions();
        IncludeOptions.getOptions((ServletRequest)synthesizedRequest, (boolean)true).setDecorationTagName("");
        StringResponseWrapper responseWrapper = new StringResponseWrapper(response);
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(resource, rdo);
        requestDispatcher.include((ServletRequest)synthesizedRequest, (ServletResponse)responseWrapper);
        return responseWrapper.getString();
    }
}

