/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.models;

import com.adobe.acs.commons.redirectmaps.impl.FakeHttpServletRequest;
import com.adobe.acs.commons.redirectmaps.models.MapEntry;
import com.adobe.acs.commons.redirectmaps.models.RedirectConfigModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Source;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
@ProviderType
public class RedirectMapModel {
    private static final Logger log = LoggerFactory.getLogger(RedirectMapModel.class);
    private static final String NO_TARGET_MSG = "No target found in entry %s";
    private static final String SOURCE_WHITESPACE_MSG = "Source path %s for content %s contains whitespace";
    private static final String WHITESPACE_MSG = "Extra whitespace found in entry %s";
    public static final String MAP_FILE_NODE = "redirectMap.txt";
    @Inject
    @Optional
    @Named(value="redirectMap.txt")
    private Resource redirectMap;
    @Inject
    @Optional
    private List<RedirectConfigModel> redirects;
    @Inject
    @Source(value="sling-object")
    private ResourceResolver resourceResolver;

    private List<MapEntry> addItems(RedirectConfigModel config, Iterator<Resource> items, String suffix, long id) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        while (items.hasNext()) {
            String[] sources;
            Resource item = items.next();
            String path = item.getPath();
            ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
            Resource child = item.getChild("jcr:content");
            if (child != null) {
                properties = child.getValueMap();
            }
            FakeHttpServletRequest mockRequest = new FakeHttpServletRequest(config.getProtocol(), config.getDomain(), config.getProtocol().equals("https") ? 443 : 80);
            String pageUrl = config.getProtocol() + "://" + config.getDomain() + this.resourceResolver.map((HttpServletRequest)mockRequest, item.getPath() + suffix);
            for (String source : sources = (String[])properties.get(config.getProperty(), String[].class)) {
                MapEntry entry = new MapEntry(id++, source, pageUrl, item.getPath());
                if (source.matches(".*\\s+.*")) {
                    String msg = String.format(SOURCE_WHITESPACE_MSG, entry.getSource(), path);
                    log.warn(msg);
                    entry.setStatus(msg);
                    entry.setValid(false);
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    private List<MapEntry> gatherEntries(RedirectConfigModel config, long id) {
        log.trace("gatherEntries");
        log.debug("Getting all of the entries for {}", (Object)config.getResource());
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        String pageQuery = "SELECT * FROM [cq:Page] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding pages with redirects with query: {}", (Object)pageQuery);
        entries.addAll(this.addItems(config, this.resourceResolver.findResources(pageQuery, "JCR-SQL2"), ".html", id));
        String assetQuery = "SELECT * FROM [dam:Asset] WHERE [jcr:content/" + config.getProperty() + "] IS NOT NULL AND (ISDESCENDANTNODE([" + config.getPath() + "]) OR [jcr:path]='" + config.getPath() + "')";
        log.debug("Finding assets with redirects with query: {}", (Object)assetQuery);
        entries.addAll(this.addItems(config, this.resourceResolver.findResources(assetQuery, "JCR-SQL2"), "", id));
        return entries;
    }

    public List<MapEntry> getEntries(long id) throws IOException {
        log.trace("getEntries");
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        java.util.Optional<InputStream> op = java.util.Optional.ofNullable(this.redirectMap).map(rm -> (InputStream)rm.adaptTo(InputStream.class));
        if (op.isPresent()) {
            InputStream is = op.get();
            for (String line : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                MapEntry entry;
                if ((entry = this.toEntry(id++, line)) == null) continue;
                entries.add(entry);
            }
        }
        if (this.redirects != null) {
            for (RedirectConfigModel r : this.redirects) {
                entries.addAll(this.gatherEntries(r, id));
            }
        } else {
            log.debug("No redirect configurations specified");
        }
        HashMap<String, Integer> sources = new HashMap<String, Integer>();
        for (MapEntry entry : entries) {
            if (!sources.containsKey(entry.getSource())) {
                sources.put(entry.getSource(), 1);
                continue;
            }
            log.trace("Found duplicate entry for {}", (Object)entry.getSource());
            sources.put(entry.getSource(), (Integer)sources.get(entry.getSource()) + 1);
        }
        sources.entrySet().removeIf(e -> (Integer)e.getValue() <= 1);
        log.debug("Found {} duplicate entries", (Object)sources.keySet().size());
        entries.stream().filter(e -> sources.containsKey(e.getSource())).forEach(e -> {
            e.setValid(false);
            e.setStatus("Duplicate entry for " + e.getSource() + ", found redirect to " + e.getTarget());
        });
        return entries;
    }

    public List<MapEntry> getInvalidEntries() throws IOException {
        log.trace("getInvalidEntries");
        ArrayList<MapEntry> invalidEntries = new ArrayList<MapEntry>();
        if (this.redirects != null) {
            List<MapEntry> entries = this.getEntries(0L);
            invalidEntries.addAll(entries.stream().filter(e -> !e.isValid()).collect(Collectors.toList()));
            log.debug("Found {} invalid entries", (Object)invalidEntries.size());
        }
        return invalidEntries;
    }

    public String getRedirectMap() throws IOException {
        log.debug("Retrieving redirect map from {}", (Object)this.redirectMap);
        StringBuilder sb = new StringBuilder();
        if (this.redirectMap != null) {
            log.debug("Loading RedirectMap file from {}", (Object)this.redirectMap);
            InputStream is = (InputStream)this.redirectMap.adaptTo(InputStream.class);
            if (is != null) {
                sb.append("# Redirect Map File\n");
                sb.append(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            } else {
                log.debug("Unable to get input stream from redirect file: {}", (Object)this.redirectMap);
            }
        } else {
            log.debug("No redirect map specified");
        }
        if (this.redirects != null) {
            for (RedirectConfigModel config : this.redirects) {
                this.writeEntries(config, sb);
            }
        } else {
            log.debug("No redirect configurations specified");
        }
        return sb.toString();
    }

    private MapEntry toEntry(long id, String l) {
        String[] seg = l.split("\\s+");
        MapEntry entry = null;
        if (!StringUtils.isBlank((CharSequence)l) && !l.startsWith("#")) {
            if (seg.length == 2) {
                entry = new MapEntry(id, seg[0], seg[1], "File");
            } else if (seg.length > 2) {
                entry = new MapEntry(id, seg[0], seg[1], "File");
                entry.setValid(false);
                entry.setStatus(String.format(WHITESPACE_MSG, l));
            } else {
                entry = new MapEntry(id, seg[0], "", "File");
                entry.setValid(false);
                entry.setStatus(String.format(NO_TARGET_MSG, l));
            }
        }
        return entry;
    }

    private void writeEntries(RedirectConfigModel config, StringBuilder sb) {
        log.trace("writeEntries");
        List<MapEntry> entries = this.gatherEntries(config, 0L);
        sb.append("\n# Dynamic entries for " + config.getResource().getPath() + "\n");
        for (MapEntry entry : entries) {
            if (!entry.isValid()) continue;
            sb.append(entry.getSource() + " " + entry.getTarget() + "\n");
        }
    }
}

