/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

public class AccessibleObjectUtil {
    public static <T> T processDualFunction(AccessibleObject o, Function<Method, T> methodFunction, Function<Field, T> fieldFunction) {
        if (o == null) {
            return null;
        }
        if (o instanceof Method) {
            return methodFunction.apply((Method)o);
        }
        if (o instanceof Field) {
            return fieldFunction.apply((Field)o);
        }
        return null;
    }

    public static Class<?> getType(AccessibleObject accessibleObject) {
        return AccessibleObjectUtil.processDualFunction(accessibleObject, Method::getReturnType, Field::getType);
    }

    public static Type getGenericType(AccessibleObject accessibleObject) {
        return AccessibleObjectUtil.processDualFunction(accessibleObject, Method::getGenericReturnType, Field::getGenericType);
    }

    public static String getFieldName(AccessibleObject o) {
        if (o == null) {
            return null;
        }
        Named named = o.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        if (o instanceof Field) {
            Field f = (Field)o;
            return f.getName();
        }
        if (o instanceof Method) {
            Method m = (Method)o;
            String name = m.getName();
            if (name.startsWith("get")) {
                return StringUtils.uncapitalize((String)name.substring(3));
            }
            if (name.startsWith("is")) {
                return StringUtils.uncapitalize((String)name.substring(2));
            }
            return name;
        }
        return null;
    }

    private AccessibleObjectUtil() {
    }
}

