/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.ActionBatch;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;

public class DeepPrune
extends ProcessDefinition
implements Serializable {
    private static final long serialVersionUID = 7526472295622776160L;
    private final transient JobManager jobManager;
    @FormField(name="Starting folder", description="Starting point for event removal", hint="/var/eventing", component=PathfieldComponent.FolderSelectComponent.class, options={"base=/", "default=/var/eventing"})
    public String startingFolder;
    @FormField(name="Minimum purge level", description="Folder depth relative to start where purge will happen", options={"default=3"})
    public int minPurgeDepth = 3;
    @FormField(name="Passes", description="Number of passes to attempt removal", hint="1,2,3", options={"default=3"})
    public int numPasses = 3;
    @FormField(name="Ignore", description="Ignore nodes which have these names (comma-delimited)", hint="rep:policy,jobs,offloading", options={"default=rep:policy,jobs,offloading"})
    public String ignore;
    private List<String> ignoreList;
    @FormField(name="Batch size", description="Max number of operations to commit at a time", hint="10", options={"default=10"})
    public int batchSize = 10;
    @FormField(name="Retries", description="Max number of retries per commit", hint="3", options={"default=3"})
    public int retryCount = 3;
    @FormField(name="Retry delay", description="Delay between retries (in milliseconds)", hint="25,50,100,...", options={"default=25"})
    public int retryWait = 25;
    @FormField(name="Delete Folders", description="Define which folders to delete, if any.", component=RadioComponent.EnumerationSelector.class, options={"default=all", "vertical"})
    private FolderRule folderRule = FolderRule.all;
    @FormField(name="Stop job queues", description="If checked, stop job queues before and resume them after the purge process", component=CheckboxComponent.class, options={"checked"})
    private boolean stopJobs = true;
    public static final String JOB_TYPE = "slingevent:Job";
    private final transient List<String> suspendedQueues = new ArrayList<String>();

    public DeepPrune(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @Override
    public void init() {
        this.ignoreList = Arrays.asList(this.ignore.split(","));
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException {
        if (this.stopJobs) {
            instance.defineCriticalAction("Stop job queues", rr, this::stopJobQueues);
        }
        if (this.numPasses > 0) {
            instance.defineAction("1st pass", rr, this::purgeJobs);
        }
        if (this.numPasses > 1) {
            instance.defineAction("2nd pass", rr, this::purgeJobs);
        }
        if (this.numPasses > 2) {
            instance.defineAction("3rd pass", rr, this::purgeJobs);
        }
        if (this.stopJobs) {
            instance.defineCriticalAction("Resume job queues", rr, this::resumeJobQueues);
        }
        instance.getInfo().setDescription(this.startingFolder);
    }

    private void stopJobQueues(ActionManager manager) {
        for (Queue q : this.jobManager.getQueues()) {
            if (q.isSuspended() && q.getStatistics().getNumberOfQueuedJobs() <= 0L) continue;
            this.suspendedQueues.add(q.getName());
            manager.deferredWithResolver(rr -> q.suspend());
        }
    }

    private boolean shouldIgnore(Resource res) {
        return res == null || this.ignoreList.contains(res.getName());
    }

    private void purgeJobs(ActionManager manager) {
        ActionBatch batch = new ActionBatch(manager, this.batchSize);
        batch.setRetryCount(this.retryCount);
        batch.setRetryWait(this.retryWait);
        TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
        visitor.setDepthFirstMode();
        visitor.setTraversalFilter(res -> visitor.isFolder((Resource)res) && !this.shouldIgnore((Resource)res));
        AtomicInteger lastLevel = new AtomicInteger(0);
        visitor.setResourceVisitor((res, level) -> {
            if (level >= this.minPurgeDepth && !this.shouldIgnore((Resource)res) && this.folderRule.matcher.apply(res.getName()).booleanValue()) {
                if (lastLevel.getAndSet((int)level) != level.intValue()) {
                    batch.commitBatch();
                }
                String path = res.getPath();
                batch.add(rr -> this.deleteResource((ResourceResolver)rr, path));
            }
        });
        visitor.setLeafVisitor((res, level) -> {
            if (!this.shouldIgnore((Resource)res)) {
                if (lastLevel.getAndSet((int)level) != level.intValue()) {
                    batch.commitBatch();
                }
                String path = res.getPath();
                batch.add(rr -> this.deleteResource((ResourceResolver)rr, path));
            }
        });
        manager.deferredWithResolver(rr -> {
            Resource res = rr.getResource(this.startingFolder);
            if (res != null) {
                visitor.accept(res);
            }
            batch.commitBatch();
        });
    }

    private void deleteResource(ResourceResolver rr, String path) throws PersistenceException {
        Actions.setCurrentItem(path);
        Resource r = rr.getResource(path);
        if (r != null) {
            rr.delete(r);
        }
    }

    private void resumeJobQueues(ActionManager manager) {
        for (Queue q : this.jobManager.getQueues()) {
            if (!this.suspendedQueues.contains(q.getName())) continue;
            manager.deferredWithResolver(rr -> q.resume());
        }
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) {
    }

    static enum FolderRule {
        all(s -> true),
        numeric(StringUtils::isNumeric),
        hexadecimal(StringUtil::isHex),
        none(s -> false);

        Function<String, Boolean> matcher;

        private FolderRule(Function<String, Boolean> m) {
            this.matcher = m;
        }
    }
}

