/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.mcp.util.FrozenAsset;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.Revision;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class AssetReport
extends ProcessDefinition
implements Serializable {
    private static final long serialVersionUID = 7526472295622776160L;
    public static final transient String SHA1 = "dam:sha1";
    public static final String NAME = "Asset Report";
    @FormField(name="Folder", description="Examines everying in this folder and all other subfolders below it", hint="/content/dam", component=PathfieldComponent.FolderSelectComponent.class, options={"default=/content/dam", "base=/content/dam"})
    private String baseFolder;
    @FormField(name="Levels", description="Determines how many levels down are included in report summary -- all levels below are rolled up into that the level.", hint="5", options={"default=5"})
    private int folderLevels;
    @FormField(name="Include subassets", description="If checked, subassets are counted and evaluated as part of the total folder size.  This takes additional time to process.", component=CheckboxComponent.class, options={"checked"})
    private boolean includeSubassets = false;
    @FormField(name="Include versions", description="If checked, versions are counted and evaluated as part of the asset size.  This takes additional time to process", component=CheckboxComponent.class, options={"checked"})
    private boolean includeVersions = false;
    private transient int depthLimit;
    private final transient GenericBlobReport report = new GenericBlobReport();
    private final transient Map<String, EnumMap<Column, Long>> reportData = new TreeMap<String, EnumMap<Column, Long>>();
    private final transient Queue<String> assetList = new ConcurrentLinkedQueue<String>();
    private final transient Queue<String> folderList = new ConcurrentLinkedQueue<String>();

    @Override
    public void init() throws RepositoryException {
        this.depthLimit = this.getDepth(this.baseFolder) + this.folderLevels;
    }

    public int getDepth(String path) {
        return (int)path.chars().filter(c -> c == 47).count();
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.report.setName(instance.getName());
        instance.defineCriticalAction("Evaluate structure", rr, this::evaluateStructure);
        instance.defineAction("First pass", rr, this::examineAssets);
        instance.defineAction("Deep scan", rr, this::evaluateDeepStructure);
        instance.defineAction("Final pass", rr, this::examineAssets);
        String detail = this.includeSubassets && this.includeVersions ? "full" : (this.includeSubassets || this.includeVersions ? "partial" : "light");
        instance.getInfo().setDescription(this.baseFolder + " - " + detail);
    }

    public void evaluateStructure(ActionManager manager) {
        TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
        visitor.setBreadthFirstMode();
        visitor.setTraversalFilter(r -> visitor.isFolder((Resource)r) && this.getDepth(r.getPath()) < this.depthLimit);
        visitor.setLeafVisitor((r, depth) -> {
            if (this.isAsset((Resource)r)) {
                this.tabulate(this.getParentPath(r.getPath()), Column.asset_count, 1L);
                this.assetList.add(r.getPath());
            } else if (visitor.isFolder((Resource)r)) {
                this.tabulate(this.getParentPath(r.getPath()), Column.subfolder_count, 1L);
                this.setValue(r.getPath(), Column.level, depth + 1);
                this.folderList.add(r.getPath());
            }
        });
        visitor.setResourceVisitor((r, depth) -> {
            this.setValue(r.getPath(), Column.level, depth + 1);
            this.tabulate(this.getParentPath(r.getPath()), Column.subfolder_count, 1L);
        });
        manager.deferredWithResolver(rr -> visitor.accept(rr.getResource(this.baseFolder)));
    }

    public void evaluateDeepStructure(ActionManager manager) {
        this.folderList.stream().peek(this.folderList::remove).forEach(folder -> manager.deferredWithResolver(rr -> {
            Actions.setCurrentItem(folder);
            TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
            visitor.setBreadthFirstMode();
            visitor.setLeafVisitor((r, depth) -> {
                if (this.isAsset((Resource)r)) {
                    this.tabulate(this.getParentPath(r.getPath()), Column.asset_count, 1L);
                    this.assetList.add(r.getPath());
                }
            });
            visitor.setResourceVisitor((r, depth) -> this.tabulate(this.getParentPath(r.getPath()), Column.subfolder_count, 1L));
            visitor.accept(rr.getResource(folder));
        }));
    }

    public void examineAssets(ActionManager manager) {
        this.assetList.stream().peek(this.assetList::remove).forEach(path -> manager.deferredWithResolver(rr -> this.examineAsset((ResourceResolver)rr, (String)path)));
        this.assetList.clear();
    }

    public boolean isAsset(Resource r) {
        String nodeType = (String)r.getValueMap().get("jcr:primaryType", String.class);
        return "dam:Asset".equals(nodeType);
    }

    private String getParentPath(String path) {
        return path.substring(0, path.lastIndexOf(47));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(String path, Column field, long amount) {
        if (this.getDepth(path) < this.depthLimit) {
            GenericBlobReport genericBlobReport = this.report;
            synchronized (genericBlobReport) {
                EnumMap<Column, Long> row = this.getReportRow(path);
                row.put(field, amount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void tabulate(String path, Column counter, long amount) {
        if (this.getDepth(path) < this.depthLimit && path.length() >= this.baseFolder.length()) {
            GenericBlobReport genericBlobReport = this.report;
            synchronized (genericBlobReport) {
                EnumMap<Column, Long> row = this.getReportRow(path);
                if (row.containsKey((Object)counter)) {
                    row.put(counter, row.get((Object)counter) + amount);
                } else {
                    row.put(counter, amount);
                }
            }
        }
        if (path.length() > this.baseFolder.length()) {
            this.tabulate(this.getParentPath(path), counter, amount);
        }
    }

    private void examineAsset(ResourceResolver rr, String assetPath) throws RepositoryException, Exception {
        Actions.setCurrentItem(assetPath);
        String folderPath = this.getParentPath(assetPath);
        HashSet<String> observedHashes = new HashSet<String>();
        Asset asset = (Asset)rr.getResource(assetPath).adaptTo(Asset.class);
        String hash = asset.getMetadataValue(SHA1);
        if (hash != null) {
            observedHashes.add(hash);
        }
        HashMap renditions = new HashMap();
        asset.listRenditions().forEachRemaining(r -> renditions.put(r.getName(), r));
        Rendition original = (Rendition)renditions.remove("original");
        this.tabulate(folderPath, Column.rendition_count, renditions.size());
        if (original != null) {
            long size = original.getSize();
            this.tabulate(folderPath, Column.original_size, size);
            this.tabulate(folderPath, Column.combined_size, size);
        }
        renditions.values().forEach(rendition -> {
            long size = rendition.getSize();
            this.tabulate(folderPath, Column.rendition_size, size);
            this.tabulate(folderPath, Column.combined_size, size);
        });
        if (this.includeSubassets) {
            DamUtil.getSubAssets((Resource)((Resource)asset.adaptTo(Resource.class))).stream().forEach(subasset -> {
                this.tabulate(folderPath, Column.subasset_count, 1L);
                long size = subasset.getRenditions().stream().collect(Collectors.summingLong(Rendition::getSize));
                this.tabulate(folderPath, Column.subasset_size, size);
                this.tabulate(folderPath, Column.combined_size, size);
            });
        }
        if (this.includeVersions) {
            for (Revision rev : asset.getRevisions(null)) {
                this.tabulate(folderPath, Column.version_count, 1L);
                Asset assetVersion = FrozenAsset.createFrozenAsset(asset, rev);
                String versionHash = assetVersion.getMetadataValue(SHA1);
                if (versionHash != null) {
                    if (observedHashes.contains(versionHash)) {
                        return;
                    }
                    observedHashes.add(versionHash);
                }
                long size = this.getTotalAssetSize(assetVersion);
                this.tabulate(folderPath, Column.version_size, size);
                this.tabulate(folderPath, Column.combined_size, size);
            }
        }
    }

    private long getTotalAssetSize(Asset asset) {
        long size = asset.getRenditions().stream().collect(Collectors.summingLong(r -> r.getSize()));
        if (this.includeSubassets && !asset.isSubAsset()) {
            size += DamUtil.getSubAssets((Resource)((Resource)asset.adaptTo(Resource.class))).stream().collect(Collectors.summingLong(this::getTotalAssetSize)).longValue();
        }
        return size;
    }

    private EnumMap<Column, Long> getReportRow(String path) {
        if (!this.reportData.containsKey(path)) {
            this.reportData.put(path, new EnumMap(Column.class));
        }
        return this.reportData.get(path);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportData, "Path", Column.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public static enum Column {
        level,
        asset_count,
        subfolder_count,
        rendition_count,
        version_count,
        subasset_count,
        original_size,
        rendition_size,
        version_size,
        subasset_size,
        combined_size;

    }
}

