/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils;

import acscommons.com.google.common.collect.Lists;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.exception.DynamicDeckDynamoException;
import com.adobe.dam.print.ids.PrintFormat;
import com.adobe.granite.workflow.exec.WorkItem;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicDeckUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDeckUtils.class);
    private static final String IDSP_SCRIPT_ARG = "<IDSP:scriptArgs>\n                            <IDSP:name>%s</IDSP:name>\n                            <IDSP:value><![CDATA[%s]]></IDSP:value>\n                        </IDSP:scriptArgs>";

    private DynamicDeckUtils() {
    }

    public static String createIDSPScriptArg(String name, Object value) {
        return String.format(IDSP_SCRIPT_ARG, name, value);
    }

    public static StringBuilder getImagePaths(List<String> assetPathList, String placeholderImagePath) {
        StringBuilder imagePaths = new StringBuilder("");
        DynamicDeckUtils.getCollectionPaths(assetPathList, imagePaths);
        imagePaths.append(placeholderImagePath);
        return imagePaths;
    }

    private static void getCollectionPaths(List<String> assetPathList, StringBuilder imagePaths) {
        if (assetPathList.isEmpty()) {
            LOGGER.debug("Asset resource list is empty");
            return;
        }
        for (String path : assetPathList) {
            imagePaths.append(path).append(",");
        }
    }

    public static StringBuilder addExportFormat(Asset master, List<PrintFormat> formats) {
        StringBuilder exportFormats = DynamicDeckUtils.getExportFormats(formats);
        for (String format : exportFormats.toString().split(",")) {
            if (!PrintFormat.INDD.getFormat().equals(format)) continue;
            DynamicDeckUtils.addExportJobProperty(master);
        }
        return exportFormats;
    }

    private static StringBuilder getExportFormats(List<PrintFormat> formats) {
        StringBuilder exportFormats = new StringBuilder("");
        if (formats != null && !formats.isEmpty()) {
            for (PrintFormat format : formats) {
                exportFormats.append(format.getFormat()).append(",");
            }
        }
        return exportFormats;
    }

    private static void addExportJobProperty(Asset master) {
        ModifiableValueMap contentProperties;
        Resource content;
        if (master == null) {
            LOGGER.debug("Master asset is null");
            return;
        }
        Resource assetResource = (Resource)master.adaptTo(Resource.class);
        if (assetResource != null && !ResourceUtil.isNonExistingResource((Resource)assetResource) && (content = assetResource.getChild("jcr:content")) != null && !ResourceUtil.isNonExistingResource((Resource)content) && content.adaptTo(ModifiableValueMap.class) != null && (contentProperties = (ModifiableValueMap)content.adaptTo(ModifiableValueMap.class)) != null) {
            contentProperties.put((Object)"idsExported", (Object)true);
            contentProperties.put((Object)"dam:assetState", (Object)"processing");
        }
    }

    public static Map<String, String> getCollectionsListForLoggedInUser(String collectionQuery, ResourceResolver resourceResolver) {
        if (StringUtils.isEmpty((CharSequence)collectionQuery)) {
            LOGGER.error("Collection query string to fetch all collections for logged-in user is null/empty");
            return Collections.emptyMap();
        }
        HashMap<String, String> collectionMap = new HashMap<String, String>();
        Iterator resultItr = resourceResolver.findResources(collectionQuery, "JCR-SQL2");
        while (resultItr.hasNext()) {
            Resource resultCollectionResource = (Resource)resultItr.next();
            LOGGER.debug("CollectionList Query Result Resource:{}", (Object)resultCollectionResource);
            if ("Lightbox".equalsIgnoreCase(resultCollectionResource.getName())) continue;
            collectionMap.put((String)resultCollectionResource.getValueMap().get("jcr:title", String.class), resultCollectionResource.getPath());
        }
        return collectionMap;
    }

    public static InputStream getInddXmlRenditionInputStream(Resource assetResource) throws DynamicDeckDynamoException {
        String renditionName = StringUtils.replace((String)assetResource.getName(), (String)".indd", (String)".xml");
        Rendition xmlRenditionAsset = Optional.ofNullable((Asset)assetResource.adaptTo(Asset.class)).map(asset -> asset.getRendition(renditionName)).orElseThrow(() -> new DynamicDeckDynamoException("Asset xml rendition doesn't exist"));
        return DynamicDeckUtils.getInputStreamByResource((Resource)xmlRenditionAsset.adaptTo(Resource.class));
    }

    public static InputStream getAssetOriginalInputStream(Resource annotatedXmlResource) throws DynamicDeckDynamoException {
        Rendition annotatedXmlRendition = ((Asset)annotatedXmlResource.adaptTo(Asset.class)).getRendition("original");
        return DynamicDeckUtils.getInputStreamByResource((Resource)annotatedXmlRendition.adaptTo(Resource.class));
    }

    private static InputStream getInputStreamByResource(Resource assetResource) throws DynamicDeckDynamoException {
        if (null == assetResource) {
            throw new DynamicDeckDynamoException("Annotated XML resource is null");
        }
        Node node = (Node)assetResource.getChild("jcr:content").adaptTo(Node.class);
        if (null == node) {
            throw new DynamicDeckDynamoException("Asset resource's data node is null");
        }
        try {
            return node.getProperty("jcr:data").getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new DynamicDeckDynamoException("Repository exception occurred while fetching the xml input stream", e);
        }
    }

    public static void commit(ResourceResolver resourceResolver) {
        if (resourceResolver == null || !resourceResolver.isLive()) {
            LOGGER.error("Resource resolver is null or not live while committing resourceResolver");
            return;
        }
        try {
            resourceResolver.refresh();
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
            }
        }
        catch (PersistenceException e) {
            LOGGER.error("Error occurred while committing resource resolver", (Throwable)e);
        }
    }

    public static List<Resource> fetchSmartCollectionResourceList(Resource smartCollectionResource) throws DynamicDeckDynamoException {
        Query query;
        try {
            query = DynamicDeckUtils.getQueryForSmartCollection(smartCollectionResource);
            if (query == null) {
                LOGGER.debug("Smart collection not found for {}", (Object)smartCollectionResource.getPath());
                return Collections.emptyList();
            }
        }
        catch (IOException | RepositoryException e) {
            throw new DynamicDeckDynamoException("Error while getting the collection query from smart collection resource", e);
        }
        query.setHitsPerPage(0L);
        return Lists.newArrayList(query.getResult().getResources());
    }

    public static String getOrCreateFolder(ResourceResolver resolver, String folderName, Resource folderParentResource) throws PersistenceException {
        Resource folderResource = folderParentResource.getChild(folderName);
        if (folderResource == null) {
            Resource createdFolderResource = DynamicDeckUtils.createFolder(resolver, folderName, folderParentResource);
            DynamicDeckUtils.commit(resolver);
            return createdFolderResource.getPath();
        }
        return folderResource.getPath();
    }

    public static Resource createFolder(ResourceResolver resolver, String folderName, Resource resource) throws PersistenceException {
        HashMap<String, String> folderResourceProp = new HashMap<String, String>();
        folderResourceProp.put("jcr:primaryType", "sling:Folder");
        return resolver.create(resource, folderName, folderResourceProp);
    }

    public static Resource findFileUnderFolderByExtension(Resource templateFolderResource, String extension) {
        Stream<Resource> resourceStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(templateFolderResource.getChildren().iterator(), 16), false);
        Optional<Resource> targetResource = resourceStream.filter(item -> StringUtils.endsWithIgnoreCase((CharSequence)item.getPath(), (CharSequence)extension)).findFirst();
        return targetResource.orElse(null);
    }

    public static Resource getAssetResourceFromPayload(WorkItem workItem, ResourceResolver resourceResolver) {
        Resource resource = null;
        if (workItem.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
            String path = workItem.getWorkflowData().getPayload().toString();
            if (path.contains("jcr:content")) {
                path = StringUtils.substringBefore((String)path, (String)"/jcr:content");
            }
            resource = resourceResolver.getResource(path);
        }
        return resource;
    }

    public static void updateUserData(Session jcrSession) {
        if (jcrSession != null) {
            try {
                jcrSession.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            }
            catch (RepositoryException e) {
                LOGGER.error("Error in repository operation::", (Throwable)e);
            }
        } else {
            LOGGER.error("JCR session object is null.");
        }
    }

    public static Asset createUniqueAsset(Resource parent, String name, ResourceResolver resolver) {
        AssetManager graniteAssetMgr = (AssetManager)resolver.adaptTo(AssetManager.class);
        if (graniteAssetMgr != null) {
            return graniteAssetMgr.createAsset(parent.getPath() + "/" + name, null, "application/x-indesign", true);
        }
        return null;
    }

    private static Query getQueryForSmartCollection(Resource resource) throws IOException, RepositoryException {
        QueryBuilder queryBuilder = (QueryBuilder)resource.getResourceResolver().adaptTo(QueryBuilder.class);
        Query query = queryBuilder.loadQuery(resource.getPath() + "/dam:query", (Session)resource.getResourceResolver().adaptTo(Session.class));
        PredicateGroup predicateGroup = query.getPredicates();
        if (!DynamicDeckUtils.hasPathPredicateForSmartCollection(predicateGroup)) {
            predicateGroup.add(DynamicDeckUtils.createPathPredicateForSmartCollection(resource));
            return queryBuilder.createQuery(predicateGroup, (Session)resource.getResourceResolver().adaptTo(Session.class));
        }
        return query;
    }

    private static boolean hasPathPredicateForSmartCollection(PredicateGroup predicateGroup) {
        if (predicateGroup.size() == 1 || predicateGroup.allRequired()) {
            for (Predicate p : predicateGroup) {
                if (!DynamicDeckUtils.isPathPredicateForSmartCollection(p)) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate createPathPredicateForSmartCollection(Resource resource) {
        Predicate pathPredicate = new Predicate("path", "path");
        pathPredicate.set("path", DamUtil.getTenantAssetsRoot((Resource)resource));
        return pathPredicate;
    }

    private static boolean isPathPredicateForSmartCollection(Predicate p) {
        return "path".equals(p.getType()) && p.hasNonEmptyValue("path") && p.get("path").startsWith("/") && !p.getBool("self");
    }
}

