/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import com.adobe.acs.commons.granite.ui.components.NamespacedTransformedResourceProvider;
import com.adobe.acs.commons.granite.ui.components.impl.include.NamespaceResourceWrapper;
import com.adobe.granite.ui.components.ExpressionResolver;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={NamespacedTransformedResourceProvider.class})
@Designate(ocd=Config.class)
public class NamespacedTransformedResourceProviderImpl
implements NamespacedTransformedResourceProvider {
    @Reference
    private ExpressionResolver expressionResolver;
    private String[] namespacedProperties;
    private boolean copyToplevelProperties;

    @Activate
    @Modified
    public void init(Config config) {
        this.namespacedProperties = config.properties();
        this.copyToplevelProperties = config.copyToplevelProperties();
    }

    @Override
    public Resource transformResourceWithNameSpacing(SlingHttpServletRequest request, Resource targetResource) {
        return new NamespaceResourceWrapper(targetResource, this.expressionResolver, request, this.namespacedProperties, this.copyToplevelProperties);
    }

    @ObjectClassDefinition(name="ACS AEM Commons - NamespacedTransformedResourceProvider", description="Transforms a resource underlying children with a namespace. Used for granite dialog snippets to be included in a granular way.")
    public static @interface Config {
        @AttributeDefinition(name="Properties", description="Properties that should be namespaced")
        public String[] properties() default {"name", "fileNameParameter", "fileReferenceParameter"};

        @AttributeDefinition(name="Copy top level properties", description="Copy the top level properties of the snippets to the include node")
        public boolean copyToplevelProperties() default true;
    }
}

