/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl.lang;

import acscommons.io.jsonwebtoken.impl.lang.UnavailableImplementationException;
import acscommons.io.jsonwebtoken.lang.Assert;
import acscommons.io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class Services {
    private static final List<ClassLoaderAccessor> CLASS_LOADER_ACCESSORS = Collections.arrayToList(new ClassLoaderAccessor[]{new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }, new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return Services.class.getClassLoader();
        }
    }, new ClassLoaderAccessor(){

        @Override
        public ClassLoader getClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    }});

    private Services() {
    }

    public static <T> List<T> loadAll(Class<T> spi) {
        Assert.notNull(spi, "Parameter 'spi' must not be null.");
        for (ClassLoaderAccessor classLoaderAccessor : CLASS_LOADER_ACCESSORS) {
            List<T> implementations = Services.loadAll(spi, classLoaderAccessor.getClassLoader());
            if (implementations.isEmpty()) continue;
            return java.util.Collections.unmodifiableList(implementations);
        }
        throw new UnavailableImplementationException(spi);
    }

    private static <T> List<T> loadAll(Class<T> spi, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi, classLoader);
        ArrayList<T> implementations = new ArrayList<T>();
        for (T implementation : serviceLoader) {
            implementations.add(implementation);
        }
        return implementations;
    }

    public static <T> T loadFirst(Class<T> spi) {
        Assert.notNull(spi, "Parameter 'spi' must not be null.");
        for (ClassLoaderAccessor classLoaderAccessor : CLASS_LOADER_ACCESSORS) {
            T result = Services.loadFirst(spi, classLoaderAccessor.getClassLoader());
            if (result == null) continue;
            return result;
        }
        throw new UnavailableImplementationException(spi);
    }

    private static <T> T loadFirst(Class<T> spi, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi, classLoader);
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader.iterator().next();
        }
        return null;
    }

    private static interface ClassLoaderAccessor {
        public ClassLoader getClassLoader();
    }
}

