/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.gson.io;

import acscommons.io.jsonwebtoken.gson.io.GsonSerializer;
import acscommons.io.jsonwebtoken.io.DeserializationException;
import acscommons.io.jsonwebtoken.io.Deserializer;
import acscommons.io.jsonwebtoken.lang.Assert;
import acscommons.io.jsonwebtoken.lang.Strings;
import com.google.gson.Gson;
import java.io.IOException;

public class GsonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final Gson gson;

    public GsonDeserializer() {
        this(GsonSerializer.DEFAULT_GSON);
    }

    public GsonDeserializer(Gson gson) {
        this(gson, Object.class);
    }

    private GsonDeserializer(Gson gson, Class<T> returnType) {
        Assert.notNull(gson, "gson cannot be null.");
        Assert.notNull(returnType, "Return type cannot be null.");
        this.gson = gson;
        this.returnType = returnType;
    }

    @Override
    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return (T)this.gson.fromJson(new String(bytes, Strings.UTF_8), this.returnType);
    }
}

