/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.commons.Externalizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@SlingServletResourceTypes(resourceTypes={"acs-commons/components/utilities/publish-url"}, methods={"GET"}, extensions={"json"})
@Designate(ocd=PublishUrlServletConfig.class)
public class PublishUrlServlet
extends SlingSafeMethodsServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String RESOURCE_TYPE = "acs-commons/components/utilities/publish-url";
    protected static final String JSON_EXTENSION = "json";
    private static final String PATH = "path";
    private static final String JSON_TYPE = "application/json";
    private String[] externalizerKeys;

    @Activate
    protected void activate(PublishUrlServletConfig config) {
        this.externalizerKeys = config.externalizerKeys();
    }

    protected void doGet(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String path = request.getParameter(PATH);
        ResourceResolver resolver = request.getResourceResolver();
        Externalizer externalizer = (Externalizer)resolver.adaptTo(Externalizer.class);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonResponse = mapper.createObjectNode();
        if (externalizer != null) {
            Arrays.asList(this.externalizerKeys).forEach(key -> {
                String capitalizedKey = StringUtils.capitalize((String)key);
                String externalLink = externalizer.externalLink(resolver, key, request.getScheme(), path);
                jsonResponse.put(capitalizedKey, externalLink);
            });
        }
        response.setContentType(JSON_TYPE);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().write(jsonResponse.toString());
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Publish URL Servlet", description="Servlet that accepts a GET request with a resource path in the path parameter, and returns a JSON object of the externalized URLs for the path.")
    public static @interface PublishUrlServletConfig {
        @AttributeDefinition(name="Externalizer environment keys", description="Keys must match the environment keys configured in the AEM Externalizer OSGi configuration.", type=AttributeType.STRING)
        public String[] externalizerKeys() default {};
    }
}

