/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushFilter;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusher;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusherModel;
import com.day.cq.replication.Agent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={DispatcherFlusherModel.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class DispatcherFlushModelImpl
implements DispatcherFlusherModel {
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private DispatcherFlusher dispatcherFlusher;
    @ValueMapValue
    @Default(values={""})
    private String replicationActionType;
    @ValueMapValue
    private List<String> paths;

    @Override
    public String getActionType() {
        return this.replicationActionType;
    }

    @Override
    public Collection<String> getPaths() {
        return this.paths != null ? this.paths : Collections.emptyList();
    }

    @Override
    public Collection<Agent> getAgents() {
        return Arrays.asList(this.dispatcherFlusher.getAgents(DispatcherFlushFilter.HIERARCHICAL));
    }

    @Override
    public boolean isFailure() {
        return StringUtils.equalsIgnoreCase((CharSequence)"/replication-error", (CharSequence)this.request.getRequestPathInfo().getSuffix());
    }

    @Override
    public List<String> getResults() {
        return Arrays.asList(StringUtils.split((String)this.request.getRequestPathInfo().getSuffix(), (String)"/"));
    }

    @Override
    public boolean isReady() {
        return StringUtils.isNotBlank((CharSequence)this.replicationActionType) && !this.paths.isEmpty() & !this.getAgents().isEmpty();
    }
}

