/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.client.impl;

import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import com.adobe.acs.commons.marketo.client.MarketoApiException;
import com.adobe.acs.commons.marketo.client.MarketoClient;
import com.adobe.acs.commons.marketo.client.MarketoError;
import com.adobe.acs.commons.marketo.client.MarketoField;
import com.adobe.acs.commons.marketo.client.MarketoForm;
import com.adobe.acs.commons.marketo.client.MarketoResponse;
import com.adobe.acs.commons.marketo.client.impl.MarketoFieldResponse;
import com.adobe.acs.commons.marketo.client.impl.MarketoFormResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.apache.poi.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MarketoClient.class})
public class MarketoClientImpl
implements MarketoClient {
    private static final Logger log = LoggerFactory.getLogger(MarketoClientImpl.class);
    private static final int SOCKET_TIMEOUT_MS = 5000;
    private static final int CONNECT_TIMEOUT_MS = 5000;
    private static final int PAGE_SIZE = 200;
    private ObjectMapper mapper = new ObjectMapper();
    private final HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(5000).setConnectTimeout(5000).build());
    @Reference
    protected ConfigurationAdmin configAdmin;

    @Activate
    public void activate() {
        try {
            Configuration[] configs = this.configAdmin.listConfigurations("(service.factoryPid=org.apache.http.proxyconfigurator)");
            if (configs != null) {
                for (Configuration config : configs) {
                    log.info("Evaluating proxy configuration: {}", (Object)config.getPid());
                    Dictionary properties = config.getProperties();
                    if (this.isEnabled(properties)) {
                        String host = (String)String.class.cast(properties.get("proxy.host"));
                        int port = (Integer)Integer.class.cast(properties.get("proxy.port"));
                        log.debug("Using proxy host: {}", (Object)host);
                        HttpHost proxyhost = new HttpHost(host, port);
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyhost);
                        this.clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                        String user = (String)String.class.cast(properties.get("proxy.user"));
                        String password = (String)String.class.cast(properties.get("proxy.password"));
                        if (!StringUtils.isNotBlank((CharSequence)user)) continue;
                        log.debug("Using proxy authentication with user: {}", (Object)user);
                        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                        credentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, password));
                        this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                        continue;
                    }
                    log.debug("Proxy configuration not enabled");
                }
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            log.error("Failed to load proxy configuration", e);
        }
    }

    private boolean isEnabled(Dictionary<String, Object> properties) {
        if (properties == null) {
            return false;
        }
        Object value = properties.get("proxy.enabled");
        if (!(value instanceof Boolean) || !((Boolean)Boolean.class.cast(value)).booleanValue()) {
            return false;
        }
        String host = (String)String.class.cast(properties.get("proxy.host"));
        return !StringUtils.isBlank((CharSequence)host);
    }

    private boolean isSuccessStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode() < 300 && response.getStatusLine().getStatusCode() >= 200;
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.clientBuilder.build();
    }

    @NotNull
    protected <T> T getApiResponse(@NotNull String url, String bearerToken, BiFunction<HttpGet, HttpResponse, ParsedResponse<T>> callback) throws MarketoApiException {
        ParsedResponse<T> parsed;
        CloseableHttpResponse response;
        HttpGet httpGet;
        CloseableHttpClient client;
        block8: {
            client = null;
            httpGet = null;
            response = null;
            client = this.getHttpClient();
            log.debug("Sending request to: {}", (Object)url);
            httpGet = new HttpGet(url);
            if (StringUtils.isNotBlank((CharSequence)bearerToken)) {
                httpGet.setHeader("Authorization", "Bearer " + bearerToken);
            }
            if (!this.isSuccessStatus((HttpResponse)(response = client.execute((HttpUriRequest)httpGet)))) {
                throw new MarketoApiException("Unexpected API response", (HttpRequestBase)httpGet, (HttpResponse)response);
            }
            parsed = callback.apply(httpGet, (HttpResponse)response);
            if (!parsed.isSuccess()) break block8;
            T t = parsed.getResult();
            IOUtils.closeQuietly((Closeable)client);
            IOUtils.closeQuietly((Closeable)response);
            return t;
        }
        try {
            try {
                throw parsed.getException();
            }
            catch (MarketoApiException mae) {
                throw mae;
            }
            catch (IOException ioe) {
                throw new MarketoApiException("Unexpected I/O Exception calling Marketo API", (HttpRequestBase)httpGet, (HttpResponse)response);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)client);
            IOUtils.closeQuietly(response);
            throw throwable;
        }
    }

    @Override
    @NotNull
    public String getApiToken(@NotNull MarketoClientConfiguration config) throws MarketoApiException {
        log.trace("getApiToken");
        String url = String.format("https://%s/identity/oauth/token?grant_type=client_credentials&client_id=%s&client_secret=%s", config.getEndpointHost(), config.getClientId(), config.getClientSecret());
        return (String)this.getApiResponse(url, null, (req, res) -> {
            String body = null;
            try {
                body = EntityUtils.toString((HttpEntity)res.getEntity());
                Map responseData = (Map)this.mapper.readValue(body, Map.class);
                String token = (String)responseData.get("access_token");
                return new ParsedResponse<String>(token);
            }
            catch (IOException e) {
                return new ParsedResponse(new MarketoApiException("Failed to get API Token", (HttpRequestBase)req, (HttpResponse)res, body));
            }
        });
    }

    @Override
    public List<MarketoField> getFields(MarketoClientConfiguration config) throws MarketoApiException {
        MarketoField[] page;
        String apiToken = this.getApiToken(config);
        ArrayList<MarketoField> fields = new ArrayList<MarketoField>();
        String base = String.format("https://%s/rest/asset/v1/form/fields.json?", config.getEndpointHost());
        int i = 0;
        while ((page = (MarketoField[])this.getApiPage(base, apiToken, i, MarketoFieldResponse.class)) != null && page.length != 0) {
            Arrays.stream(page).forEach(fields::add);
            ++i;
        }
        return fields;
    }

    @Nullable
    private <T, R extends MarketoResponse<T>> T[] getApiPage(@NotNull String urlBase, @NotNull String token, int page, Class<R> responseType) throws MarketoApiException {
        log.trace("getApiPage({})", (Object)page);
        int offset = 200 * page;
        String url = String.format("%smaxReturn=%s&offset=%s", urlBase, 200, offset);
        return (Object[])this.getApiResponse(url, token, (req, res) -> {
            String body = null;
            try {
                body = EntityUtils.toString((HttpEntity)res.getEntity());
                MarketoResponse response = (MarketoResponse)this.mapper.readValue(body, responseType);
                if (response.getErrors() != null && response.getErrors().length > 0) {
                    throw new IOException("Retrieved errors in response: " + Arrays.stream(response.getErrors()).map(MarketoError::getMessage).collect(Collectors.joining(", ")));
                }
                if (!response.isSuccess()) {
                    throw new IOException("Retrieved non-success response");
                }
                return new ParsedResponse<T[]>(response.getResult());
            }
            catch (IOException ioe) {
                return new ParsedResponse(new MarketoApiException("Failed to retrieve Marketo API Page", (HttpRequestBase)req, (HttpResponse)res, body));
            }
        });
    }

    @Override
    public List<MarketoForm> getForms(@NotNull MarketoClientConfiguration config) throws MarketoApiException {
        MarketoForm[] page;
        String apiToken = this.getApiToken(config);
        ArrayList<MarketoForm> forms = new ArrayList<MarketoForm>();
        String base = String.format("https://%s/rest/asset/v1/forms.json?status=approved&", config.getEndpointHost());
        int i = 0;
        while ((page = (MarketoForm[])this.getApiPage(base, apiToken, i, MarketoFormResponse.class)) != null && page.length != 0) {
            Arrays.stream(page).forEach(forms::add);
            ++i;
        }
        return forms;
    }

    class ParsedResponse<T> {
        private final boolean success;
        private final MarketoApiException exception;
        private final T result;

        public ParsedResponse(T result) {
            this.success = true;
            this.result = result;
            this.exception = null;
        }

        public ParsedResponse(MarketoApiException exception) {
            this.success = false;
            this.result = null;
            this.exception = exception;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public MarketoApiException getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }
    }
}

