/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="type", value={"letter-pillar-box"})})
@Service
public class LetterPillarBoxImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(LetterPillarBoxImageTransformerImpl.class);
    static final String TYPE = "letter-pillar-box";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_WIDTH_ALIAS = "w";
    private static final String KEY_HEIGHT = "height";
    private static final String KEY_HEIGHT_ALIAS = "h";
    private static final String KEY_ALPHA = "alpha";
    private static final String KEY_ALPHA_ALIAS = "a";
    private static final String KEY_COLOR = "color";
    private static final String KEY_COLOR_ALIAS = "c";
    private static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int MAX_ALPHA = 255;
    private static final int DEFAULT_MAX_DIMENSION = 50000;
    private int maxDimension = 50000;
    @Property(label="Max dimension in px", description="Maximum size height and width can be re-sized to. [ Default: 50000 ]", intValue={50000})
    public static final String PROP_MAX_DIMENSION = "max-dimension";

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        Dimension newSize = this.getResizeDimensions(properties, layer);
        Color color = this.getColor(properties);
        Layer resized = this.resize(layer, newSize);
        Layer result = this.build(newSize, resized, color);
        return result;
    }

    private Layer build(Dimension size, Layer img, Color color) {
        Layer merged = this.createLayer(size, color);
        int startXpos = 0;
        int startYpos = 0;
        int imgHeight = img.getHeight();
        int imgWidth = img.getWidth();
        if (imgHeight == size.height) {
            startXpos = this.calculateStartPosition(size.width, imgWidth);
        } else if (imgWidth == size.width) {
            startYpos = this.calculateStartPosition(size.height, imgHeight);
        }
        merged.blit(img, startXpos, startYpos, imgWidth, imgHeight, 0, 0);
        return merged;
    }

    Layer createLayer(Dimension size, Color color) {
        return new Layer(size.width, size.height, (Paint)color);
    }

    private Layer resize(Layer original, Dimension newDimensions) {
        Dimension origDimensions = new Dimension(original.getWidth(), original.getHeight());
        int fixedDimension = this.getFixedDimension(origDimensions, newDimensions);
        float newWidth = newDimensions.width;
        float newHeight = newDimensions.height;
        if (fixedDimension < 0) {
            newWidth = (float)(origDimensions.width * newDimensions.height) / (float)origDimensions.height;
        } else if (fixedDimension > 0) {
            newHeight = (float)(newDimensions.width * origDimensions.height) / (float)origDimensions.width;
        }
        original.resize(Math.round(newWidth), Math.round(newHeight));
        return original;
    }

    private int getFixedDimension(Dimension start, Dimension end) {
        double startRatio = start.getWidth() / start.getHeight();
        double finalRatio = end.getWidth() / end.getHeight();
        return Double.compare(startRatio, finalRatio);
    }

    private Dimension getResizeDimensions(ValueMap properties, Layer layer) {
        int targetWidth = (Integer)properties.get(KEY_WIDTH, (Object)((Integer)properties.get(KEY_WIDTH_ALIAS, (Object)0)));
        int targetHeight = (Integer)properties.get(KEY_HEIGHT, (Object)((Integer)properties.get(KEY_HEIGHT_ALIAS, (Object)0)));
        int startWidth = layer.getWidth();
        int startHeight = layer.getHeight();
        if (targetWidth > this.maxDimension) {
            targetWidth = this.maxDimension;
        }
        if (targetHeight > this.maxDimension) {
            targetHeight = this.maxDimension;
        }
        if (targetWidth < 1 && targetHeight < 1) {
            targetWidth = startWidth;
            targetHeight = startHeight;
        } else if (targetWidth < 1) {
            float aspect = (float)targetHeight / (float)startHeight;
            targetWidth = Math.round((float)startWidth * aspect);
        } else if (targetHeight < 1) {
            float aspect = (float)targetWidth / (float)startWidth;
            targetHeight = Math.round((float)startHeight * aspect);
        }
        return new Dimension(targetWidth, targetHeight);
    }

    private Color getColor(ValueMap properties) {
        String hexcolor = (String)properties.get(KEY_COLOR, (Object)((String)properties.get(KEY_COLOR_ALIAS, String.class)));
        int alpha = this.normalizeAlpha(((Double)properties.get(KEY_ALPHA, (Object)((Double)properties.get(KEY_ALPHA_ALIAS, (Object)0.0)))).floatValue());
        Color color = TRANSPARENT;
        if (hexcolor != null) {
            try {
                Color parsed = Color.decode("0x" + hexcolor);
                color = new Color(parsed.getRed(), parsed.getGreen(), parsed.getBlue(), alpha);
            }
            catch (NumberFormatException ex) {
                log.warn("Invalid hex color specified: {}", (Object)hexcolor);
                color = TRANSPARENT;
            }
        }
        return color;
    }

    private int normalizeAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        } else if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        return Math.round(alpha * 255.0f);
    }

    private int calculateStartPosition(int originalSize, int newSize) {
        int diff = originalSize - newSize;
        int start = diff / 2;
        return start;
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        this.maxDimension = PropertiesUtil.toInteger((Object)config.get(PROP_MAX_DIMENSION), (int)50000);
    }
}

