/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.rule.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.rule.AbstractHttpCacheHandlingRule;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

@Component
@Service
public class HonorCacheControlHeaders
extends AbstractHttpCacheHandlingRule {
    private static final String KEY_CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String[] VALUES_CACHE_CONTROL = new String[]{"no-cache", "no-store", "must-revalidate"};
    private static final String KEY_PRAGMA = "Pragma";
    private static final String[] VALUES_PRAGMA = new String[]{"no-cache"};

    @Override
    public boolean onResponseCache(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig, CacheContent cacheContent) {
        List<String> pragmaValues;
        List<String> cacheControlValues;
        if (cacheContent.getHeaders().containsKey(KEY_CACHE_CONTROL_HEADER) && CollectionUtils.containsAny(cacheControlValues = cacheContent.getHeaders().get(KEY_CACHE_CONTROL_HEADER), Arrays.asList(VALUES_CACHE_CONTROL))) {
            return false;
        }
        return !cacheContent.getHeaders().containsKey(KEY_PRAGMA) || !CollectionUtils.containsAny(pragmaValues = cacheContent.getHeaders().get(KEY_PRAGMA), Arrays.asList(VALUES_PRAGMA));
    }
}

