/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HttpCacheConfigExtension.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.ranking:Integer=2147483647", "webconsole.configurationFactory.nameHint=Config name: [ config.name ]"}, reference={@Reference(name="cacheConfigExtensions", bind="bindCacheConfigExtension", unbind="unbindCacheConfigExtension", service=HttpCacheConfigExtension.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE)})
@Designate(ocd=Config.class, factory=true)
public class CombinedCacheConfigExtension
implements HttpCacheConfigExtension {
    private static final Logger log = LoggerFactory.getLogger(CombinedCacheConfigExtension.class);
    private RankedServices<HttpCacheConfigExtension> cacheConfigExtensions = new RankedServices(Order.ASCENDING);
    private Config cfg;

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        if (!this.cfg.httpcache_config_extension_combiner_require_all_to_accept()) {
            for (HttpCacheConfigExtension extension : this.cacheConfigExtensions) {
                if (!extension.accepts(request, cacheConfig)) continue;
                log.debug("require one: extension {} accepting: {}", (Object)this.cfg.config_name(), (Object)extension.getClass().getName());
                return true;
            }
            return false;
        }
        for (HttpCacheConfigExtension extension : this.cacheConfigExtensions) {
            if (extension.accepts(request, cacheConfig)) continue;
            log.debug("require all: extension {} not accepting: {}", (Object)this.cfg.config_name(), (Object)extension.getClass().getName());
            return false;
        }
        return true;
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.cfg = config;
    }

    protected void bindCacheConfigExtension(HttpCacheConfigExtension extension, Map<String, Object> properties) {
        if (extension != this) {
            this.cacheConfigExtensions.bind((Object)extension, properties);
        }
    }

    protected void unbindCacheConfigExtension(HttpCacheConfigExtension extension, Map<String, Object> properties) {
        if (extension != this) {
            this.cacheConfigExtensions.unbind((Object)extension, properties);
        }
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension Combiner", description="Aggregates multiple extensions into a single referencable extension.")
    public static @interface Config {
        @AttributeDefinition(name="HttpCacheConfigExtension service PIDs", description="Service PIDs of target implementation of HttpCacheConfigExtensions to be combined and used.")
        public String cacheConfigExtensions_target();

        @AttributeDefinition(name="Require all extensions to accept", description="")
        public boolean httpcache_config_extension_combiner_require_all_to_accept() default true;

        @AttributeDefinition(name="Config Name")
        public String config_name() default "";
    }
}

