/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.xlsx;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import co.elastic.thumbnails4j.xlsx.XlsxToHtmlSerializer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSXThumbnailer
implements Thumbnailer {
    Logger logger = LoggerFactory.getLogger(XLSXThumbnailer.class);

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Workbook workbook = WorkbookFactory.create((File)input);){
                return this.getThumbnails(workbook, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to parse XLSX: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Workbook workbook = WorkbookFactory.create((InputStream)input);){
                return this.getThumbnails(workbook, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to parse XLSX: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
    }

    private List<BufferedImage> getThumbnails(Workbook workbook, List<Dimensions> dimensions) {
        XlsxToHtmlSerializer serializer = new XlsxToHtmlSerializer(workbook);
        byte[] htmlBytes = serializer.getHtml();
        BufferedImage image = ThumbnailUtils.clipHtmlToImage((byte[])htmlBytes, (Dimensions)ThumbnailUtils.getMaxInMemoryBuffer());
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        for (Dimensions singleDimension : dimensions) {
            results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
        }
        return results;
    }
}

