/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.pdf;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import co.elastic.thumbnails4j.pdf.NullCache;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFThumbnailer
implements Thumbnailer {
    private static Logger logger = LoggerFactory.getLogger(PDFThumbnailer.class);
    private static final double BUFFER_MULTIPLIER = 2.0;

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PDDocument document = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBufferedFile(input));){
                return this.getThumbnails(document, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Could not load input as PDF: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PDDocument document = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(input));){
                return this.getThumbnails(document, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Could not load input as PDF: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
    }

    private List<BufferedImage> getThumbnails(PDDocument document, List<Dimensions> dimensions) throws IOException {
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        document.setResourceCache((ResourceCache)new NullCache());
        Integer thumbnailPageIndex = this.thumbnailPageIndex(document);
        if (thumbnailPageIndex != null) {
            BufferedImage image = new PDFRenderer(document).renderImage(thumbnailPageIndex.intValue(), 0.5f);
            for (Dimensions singleDimension : dimensions) {
                results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
            }
        }
        return results;
    }

    private Integer thumbnailPageIndex(PDDocument document) {
        int i = 0;
        while (i < document.getNumberOfPages()) {
            PDPage page = document.getPage(i);
            COSDictionary dictionary = (COSDictionary)this.unwrapPDFObject(page.getCOSObject().getItem(COSName.RESOURCES));
            List<COSDictionary> images = this.collectImages(dictionary);
            if (this.imagesFitPage(images, page)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    private boolean imagesFitPage(List<COSDictionary> images, PDPage page) {
        PDRectangle pageDimensions = page.getBBox();
        boolean allMatch = true;
        for (COSDictionary image : images) {
            boolean bl = allMatch = allMatch && (double)image.getInt(COSName.WIDTH, 0) <= (double)pageDimensions.getWidth() * 2.0 && (double)image.getInt(COSName.HEIGHT, 0) <= (double)pageDimensions.getHeight() * 2.0;
        }
        return allMatch;
    }

    private List<COSDictionary> collectImages(COSDictionary dictionary) {
        ArrayList<COSDictionary> values = new ArrayList<COSDictionary>();
        for (Map.Entry entry : dictionary.entrySet()) {
            COSBase value = this.unwrapPDFObject((COSBase)entry.getValue());
            if (!(value instanceof COSDictionary)) continue;
            if (this.isImage((COSDictionary)value)) {
                values.add((COSDictionary)value);
                continue;
            }
            values.addAll(this.collectImages((COSDictionary)value));
        }
        return values;
    }

    private COSBase unwrapPDFObject(COSBase object) {
        return object instanceof COSObject ? ((COSObject)object).getObject() : object;
    }

    private boolean isImage(COSDictionary dictionary) {
        return dictionary.getCOSName(COSName.TYPE) == COSName.XOBJECT && dictionary.getCOSName(COSName.SUBTYPE) == COSName.IMAGE && dictionary.containsKey(COSName.WIDTH) && dictionary.containsKey(COSName.HEIGHT);
    }
}

