/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter.cache;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.api.constants.CacheConstants;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.BlackListMemoryCache;
import cn.stylefeng.roses.kernel.security.blackwhite.cache.WhiteListMemoryCache;
import cn.stylefeng.roses.kernel.security.captcha.cache.CaptchaMemoryCache;
import cn.stylefeng.roses.kernel.security.count.cache.CountValidateMemoryCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class SecurityMemoryCacheAutoConfiguration {
    @Bean(value={"captchaCache"})
    public CacheOperatorApi<String> captchaMemoryCache() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)120000L);
        return new CaptchaMemoryCache(timedCache);
    }

    @Bean(value={"blackListCache"})
    public CacheOperatorApi<String> blackListMemoryCache() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        return new BlackListMemoryCache(timedCache);
    }

    @Bean(value={"whiteListCache"})
    public CacheOperatorApi<String> whiteListMemoryCache() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        return new WhiteListMemoryCache(timedCache);
    }

    @Bean(value={"countValidateCache"})
    public CacheOperatorApi<Long> countValidateMemoryCache() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        return new CountValidateMemoryCache(timedCache);
    }
}

