/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter;

import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.security.api.BlackListApi;
import cn.stylefeng.roses.kernel.security.api.CountValidatorApi;
import cn.stylefeng.roses.kernel.security.api.WhiteListApi;
import cn.stylefeng.roses.kernel.security.blackwhite.BlackListService;
import cn.stylefeng.roses.kernel.security.blackwhite.WhiteListService;
import cn.stylefeng.roses.kernel.security.count.DefaultCountValidator;
import cn.stylefeng.roses.kernel.security.starter.cache.SecurityMemoryCacheAutoConfiguration;
import cn.stylefeng.roses.kernel.security.starter.cache.SecurityRedisCacheAutoConfiguration;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SecurityMemoryCacheAutoConfiguration.class, SecurityRedisCacheAutoConfiguration.class})
public class CounterAutoConfiguration {
    @Resource(name="blackListCache")
    private CacheOperatorApi<String> blackListCache;
    @Resource(name="whiteListCache")
    private CacheOperatorApi<String> whiteListCache;
    @Resource(name="countValidateCache")
    private CacheOperatorApi<Long> countValidateCache;

    @Bean
    public BlackListApi blackListApi() {
        return new BlackListService(this.blackListCache);
    }

    @Bean
    public WhiteListApi whiteListApi() {
        return new WhiteListService(this.whiteListCache);
    }

    @Bean
    public CountValidatorApi countValidatorApi() {
        return new DefaultCountValidator(this.countValidateCache);
    }
}

