/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.i18n;

import cn.stylefeng.roses.kernel.i18n.api.TranslationApi;
import cn.stylefeng.roses.kernel.i18n.api.pojo.TranslationDict;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TranslationContainer
implements TranslationApi {
    private static final Map<String, Map<String, String>> TRAN_DICT_CONTAINER = new ConcurrentHashMap<String, Map<String, String>>();

    public void init(List<TranslationDict> translationDict) {
        for (TranslationDict translationItem : translationDict) {
            this.addTranslationDict(translationItem);
        }
    }

    public Map<String, String> getTranslationDictByLanguage(String tranLanguageCode) {
        return TRAN_DICT_CONTAINER.get(tranLanguageCode);
    }

    public void addTranslationDict(TranslationDict translationDict) {
        String tranLanguageCode = translationDict.getTranLanguageCode();
        Map<String, String> languageDict = TRAN_DICT_CONTAINER.get(tranLanguageCode);
        if (languageDict == null) {
            languageDict = new HashMap<String, String>();
        }
        languageDict.put(translationDict.getTranCode(), translationDict.getTranValue());
        TRAN_DICT_CONTAINER.put(tranLanguageCode, languageDict);
    }

    public void deleteTranslationDict(String tranLanguageCode, String tranCode) {
        Map<String, String> languageDict = TRAN_DICT_CONTAINER.get(tranLanguageCode);
        if (languageDict == null) {
            return;
        }
        languageDict.remove(tranCode);
        TRAN_DICT_CONTAINER.put(tranLanguageCode, languageDict);
    }
}

