/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.configuration;

import cn.herodotus.engine.rest.client.definition.OpenApiServerResolver;
import cn.herodotus.engine.rest.client.processor.DefaultOpenApiServerResolver;
import cn.herodotus.engine.rest.core.context.HerodotusApplicationContext;
import cn.herodotus.engine.rest.core.properties.EndpointProperties;
import cn.herodotus.engine.rest.core.properties.PlatformProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={PlatformProperties.class, EndpointProperties.class})
public class RestClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestClientConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Rest Client] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public HerodotusApplicationContext herodotusApplicationContext(ApplicationContext applicationContext, PlatformProperties platformProperties, EndpointProperties endpointProperties, ServerProperties serverProperties) {
        HerodotusApplicationContext contextHolder = new HerodotusApplicationContext(applicationContext, platformProperties, endpointProperties, serverProperties);
        log.trace("[Herodotus] |- Bean [Herodotus Context Holder] Auto Configure.");
        return contextHolder;
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiServerResolver openApiServerResolver(HerodotusApplicationContext herodotusApplicationContext) {
        DefaultOpenApiServerResolver defaultOpenApiServerResolver = new DefaultOpenApiServerResolver(herodotusApplicationContext);
        log.trace("[Herodotus] |- Bean [Open Api Server Resolver] Auto Configure.");
        return defaultOpenApiServerResolver;
    }
}

