/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.configuration;

import cn.herodotus.engine.assistant.core.annotation.ConditionalOnSwaggerEnabled;
import cn.herodotus.engine.rest.client.configuration.RestClientConfiguration;
import cn.herodotus.engine.rest.client.definition.OpenApiServerResolver;
import cn.herodotus.engine.rest.client.properties.SwaggerProperties;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RestClientConfiguration.class})
@ConditionalOnSwaggerEnabled
@EnableConfigurationProperties(value={SwaggerProperties.class})
@SecuritySchemes(value={@SecurityScheme(name="HERODOTUS_AUTH", type=SecuritySchemeType.OAUTH2, bearerFormat="JWT", scheme="bearer", flows=@OAuthFlows(password=@OAuthFlow(authorizationUrl="${herodotus.endpoint.authorization-uri}", tokenUrl="${herodotus.endpoint.access-token-uri}", refreshUrl="${herodotus.endpoint.access-token-uri}", scopes={@OAuthScope(name="all")}), clientCredentials=@OAuthFlow(authorizationUrl="${herodotus.endpoint.authorization-uri}", tokenUrl="${herodotus.endpoint.access-token-uri}", refreshUrl="${herodotus.endpoint.access-token-uri}", scopes={@OAuthScope(name="all")})))})
public class OpenApiConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OpenApiConfiguration.class);
    private final OpenApiServerResolver openApiServerResolver;

    @Autowired
    public OpenApiConfiguration(OpenApiServerResolver openApiServerResolver) {
        this.openApiServerResolver = openApiServerResolver;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Web Rest Swagger] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAPI createOpenApi() {
        return new OpenAPI().servers(this.openApiServerResolver.getServers()).info(new Info().title("Herodotus Cloud").description("Herodotus Cloud Microservices Architecture").version("Swagger V3").license(new License().name("Apache 2.0").url("http://www.apache.org/licenses/"))).externalDocs(new ExternalDocumentation().description("Herodotus Cloud Documentation").url(" https://www.herodotus.cn"));
    }
}

