/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.configuration;

import cn.herodotus.engine.rest.client.feign.FeignErrorDecoder;
import cn.herodotus.engine.rest.client.feign.FeignInnerContract;
import cn.herodotus.engine.rest.client.feign.FeignRequestInterceptor;
import feign.Contract;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class FeignConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FeignConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Contract contract() {
        return new FeignInnerContract();
    }

    @Bean
    @ConditionalOnMissingBean(value={FeignRequestInterceptor.class})
    public RequestInterceptor feignRequestInterceptor() {
        FeignRequestInterceptor feignRequestInterceptor = new FeignRequestInterceptor();
        log.trace("[Herodotus] |- Bean [Feign Request Interceptor] Auto Configure.");
        return feignRequestInterceptor;
    }

    @Bean
    public ErrorDecoder errorDecoder() {
        return new FeignErrorDecoder();
    }

    @Bean
    public Logger.Level logger() {
        return Logger.Level.BASIC;
    }

    @Bean
    public Request.Options options() {
        return new Request.Options(10L, TimeUnit.SECONDS, 60L, TimeUnit.SECONDS, true);
    }

    @Bean
    public Retryer feignRetryer() {
        return new Retryer.Default();
    }
}

