/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.condition;

import cn.herodotus.engine.rest.core.constants.RestPropertyFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class UseSimpleRestClientCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(UseSimpleRestClientCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean isOkHttpEnabled = RestPropertyFinder.isOpenFeignOkHttpEnabled((Environment)context.getEnvironment());
        boolean isHttpClientEnabled = RestPropertyFinder.isOpenFeignHttpClientEnabled((Environment)context.getEnvironment());
        boolean result = !isOkHttpEnabled && !isHttpClientEnabled;
        log.debug("[Herodotus] |- Condition [Use Simple Rest Client] value is [{}]", (Object)result);
        return result;
    }
}

